@extends($theme.'frontend.layouts.master')
@section('title',__('Login & Invest To Earn'))
@section('content')

<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="user-login-form-area">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-8 col-12 mx-auto mb-50 align-self-center">
                    <img src="{{__('assets/images/login.png')}}" alt="img">
                </div>
                <div class="col-lg-5 col-md-8 col-12 mx-auto mb-50">
                    <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                        <div class="section-title mb-4 pb-2 text-center">
                            <h2 class="title text-white">{{__('Login')}} </h2>
                        </div>
                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="row">
                                @if ($general->social_api != 0)
                                    <div class="social__login">
                                        <a href="{{route('login.google')}}" class="btn__login btn__google"><i class="fab fa-google"></i> {{__('GOOGLE')}}</a>
                                
                                        <a href="{{route('login.facebook')}}" class="btn__login btn__facebook"><i class="fab fa-facebook"></i> {{__('FACEBOOK')}}</a>
                                    </div>
                                @endif
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Email')}} :</label>
                                        <input type="email" name="email" placeholder="Your Email" required autocomplete="email" autofocus>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Password')}} :</label>
                                        <input type="password" name="password" placeholder="Password" required autocomplete="current-password">
                                    </div>
                                </div>
                                <div class="col-12 text-end">
                                    <a  href="{{route('user.showEmailForm')}}" class="text-white">{{__('Forget Password ?')}}</a>
                                </div>
                                @if ($general->g_captcha == 1)
                                    <div class="col-md-12">
                                        <div class="g-recaptcha" data-sitekey="{{$general->captcha_key_one}}"></div>
                                        @if ($errors->has('g-recaptcha-response'))
                                            <span class="invalid-feedback" style="display: block;">
                                                <strong>{{$errors->first('g-recaptcha-response')}}</strong>
                                            </span>
                                        @endif
                                    </div>
                                @endif
                                <div class="col-12 text-start mt-3 mb-3">
                                    <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5 w-100">{{__('Login')}}</button>
                                </div>
                                <div class="col-md-12 text-center">
                                    <a href="{{route('register')}}" class="text-white">{{__('Do not have an account ?')}}</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
