@extends($theme.'frontend.layouts.master')
@section('title',__('Register From Here'))
@section('content')

<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="user-login-form-area">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-6 col-md-8 col-12 mx-auto mb-50">
                    <img src="{{__('assets/images/login.png')}}" alt="img">
                </div>
                <div class="col-lg-5 col-md-8 col-12 mx-auto mb-50">
                    <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                        <div class="section-title mb-4 pb-2 text-center">
                            <h2 class="title text-white">{{__('Register')}} </h2>
                        </div>
                        <form method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="row">
                                @isset($refName)
                                    <div class="col-md-12">
                                        <label class="text-white">{{__('Referrer Name')}} :</label>
                                        <input type="text" disabled value="{{$refName->name}}" placeholder="{{__('Enter Full Name')}}">
                                    </div>
                                    <input type="hidden" value="{{$refName->id}}" name="ref_id">
                                @endisset
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Full Name')}} :</label>
                                        <input type="text" name="name" required value="{{old('name')}}" placeholder="{{__('Enter Full Name')}}" autocomplete="off" autofocus>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Email')}} :</label>
                                        <input type="email" name="email" required autocomplete="off" placeholder="{{__('Enter Mail Address')}}" value="{{old('email')}}" autofocus>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Password')}} :</label>
                                        <input type="password" name="password" placeholder="{{__('Enter Password')}}" required>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="single-input-inner">
                                        <label class="text-white">{{__('Confirm Password')}} :</label>
                                        <input type="password" name="password_confirmation" placeholder="{{__('Confirm Password')}}" required>
                                    </div>
                                </div>
                                <div class="col-12 mt-2 mb-3">
                                    <button type="submit" class="btn btn-base w-100 border-radius-5 pe-5 ps-5">{{__('Register')}}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
