@extends($theme.'frontend.layouts.master')
@section('title', __('Authorize.Net'))
@section('content')

@php
    $months = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
@endphp

<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Authorize.Net Payment')}} </h2>
                    </div>
                    <form id="payment-card-info" method="post" action="{{ route('authorize.dopay.online') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="single-input-inner">
                                    <label>{{__('Name on Card')}} :</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                        <input class="form-control" type="text" id="owner" name="owner" value="{{'Simon'}}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="single-input-inner">
                                    <label>{{__('Card Number')}} :</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                        <input type="text" class="form-control" id="cardNumber" name="cardNumber" value="{{'4111 1111 1111 1111'}}" required>
                                    </div>
                                </div>
                            </div>
							<div class="col-md-3">
								<label>{{__('CVC')}}</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="fa fa-address-card"></i></span>
                                    <input class="form-control" type="text" id="cvv" name="cvv" value="{{'123'}}" required>
                                </div>
							</div>
							<div class="col-md-3">
								<label>{{__('Amount')}}</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="fa fa-dollar-sign"></i></span>
                                    <input class="form-control" type="number" id="amount" readonly name="amount" min="1" value="{{ $usd }}" required>
                                </div>
							</div>
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label>{{__('Expiration Month')}}</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            <select class="form-select author_month" id="expiration-month" name="expiration-month">
                                                @foreach($months as $k=>$v)
                                                    <option value="{{ $k }}" {{ old('expiration-month') == $k ? 'selected' : '' }}>{{ $v }}</option>                                                        
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label>{{__('Years')}}</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            <select class="form-select author_year" id="expiration-year" name="expiration-year">
                                                @for($i = date('Y'); $i <= (date('Y') + 15); $i++)
                                                <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="input-group mb-3">
                                    <img class="author_img" src="{{ asset('assets/images/gateway/visa.png') }}" id="visa">
                                    <img class="author_img" src="{{ asset('assets/images/gateway/mastercard.jpg') }}" id="mastercard">
                                    <img class="author_img" src="{{ asset('assets/images/gateway/american-express.png') }}" id="amex">
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Pay Now')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection