@extends($theme.'frontend.layouts.master')
@section('title',__('Invest History'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">{{__('Invest History')}}</h4>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table site-table">
                        <thead>
                            <tr>
                                <th> {{__('Package')}} </th>
                                <th> {{__('Type')}} </th>
                                <th> {{__('Invest Amount')}} </th>
                                <th> {{__('Payable')}} </th>
                                <th> {{__('Already Return')}} </th>
                                <th> {{__('Next Return Time')}} </th>
                                <th> {{__('Status')}} </th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($plans as $data)
                            <tr>
                                <td data-caption="{{__('Package')}}">{{__($data->plan_name)}}</td>
                                <td data-caption="{{__('Type')}}">
                                    @switch($data->get_period)
                                        @case(1)
                                        {{__('Hourly')}}
                                        @break
                                        @case(24)
                                        {{__('Daily')}}   @break
                                        @case(168)
                                        {{__('Weekly')}}   @break
                                        @case(720)
                                        {{__('Monthly')}}   @break
                                        @case(2880)
                                        {{__('Quarterly')}}   @break
                                        @case(8640)
                                        {{__('Yearly')}}   @break
                                    @endswitch
                                </td>
                                <td data-caption="{{__('Invest Amount')}}">{{$data->invest_amount}}  {{$general->currency}}</td>
                                <td data-caption="{{__('Payable')}}">{{$data->get_percent}}%/{{is_null($data->get_action) ? 'Lifetime': $data->get_action.' Times'}}  </td>
                                <td data-caption="{{__('Already Return')}}">{{$data->took_action}} {{__('TIMES')}}</td>
                                <td data-caption="{{__('Next Return Time')}}">{{date('d/m/y  h:i A',strtotime($data->next_time))}}</td>
                                <td data-caption="{{__('Status')}}">
                                    @if($data->status == 0)
                                        <span class="badge bg-primary">{{__('Continue')}}</span>
                                    @else
                                        <span class="badge bg-success">{{__('Complete')}}</span>
                                    @endif
                                </td>
                            </tr>
                            @empty 
                            <tr>
                                <td colspan="6" class="text-center">
                                    <div class="no-data-found">
                                        <span class="icon"><i class="far fa-folder-open"></i></span>
                                        <p class="mb-0">{{__('No Data Found')}}</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12 text-center">
                {{$plans->links()}}
            </div>
        </div>
    </div>
</div>
@endsection
