@extends($theme.'frontend.layouts.master')
@section('title',__('Edit Your Profile'))
@section('content')
<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row gy-4 justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title mb-0">{{__('Update Profile')}} </h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('profile.update') }}">
                            @csrf
                            <div class="row gy-3">
                                <div class="col-md-6">
                                    <label>{{__('Name')}}</label>
                                    <input name="name" value="{{$user->name}}" class="form-control" type="text">
                                </div>
                                <div class="col-md-6">
                                    <label>{{__('Mobile')}}</label>
                                    <input name="mobile" value="{{$user->mobile}}" class="form-control" type="text">
                                </div>
                                <div class="col-md-6">
                                    <label>{{__('Gender')}}</label>
                                    <select class="form-select" name="gender">
                                        <option {{$user->gender == 0? 'selected':''}} value="1">{{__('Male')}}</option>
                                        <option {{$user->gender == 1? 'selected':''}} value="0">{{__('Female')}}</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>{{__('Zip-Code')}}</label>
                                    <input name="zip_code" value="{{$user->zip_code}}" class="form-control" type="text">
                                </div>
                                <div class="col-md-6">
                                    <label>{{__('City')}}</label>
                                    <input name="city" value="{{$user->city}}" class="form-control" type="text">
                                </div>
                                <div class="col-md-6 autocomplete">
                                    <label>{{__('Country')}}</label>
                                    <input id="myInput" name="country" class="form-control" value="{{$user->country}}" type="text" autocomplete="off">
                                </div>
                                
                                <div class="col-md-12">
                                    <label>{{__('Address')}}</label>
                                    <input name="address" value="{{$user->address}}" class="form-control" type="text">
                                </div>
            
                                <div class="col-12 text-center mt-3 mb-3">
                                    <button type="submit" class="btn btn-base border-radius-5 w-100">{{__('Submit')}}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title mb-0">{{__('Change Password')}} </h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('password.update') }}">
                            @csrf
                            <div class="row gy-3">
                                <div class="col-md-12">
                                    <label>{{__('Current Password')}} :</label>
                                    <input type="password" name="current_password" class="form-control" required>
                                </div>
                                <div class="col-md-12">
                                    <label>{{__('New Password')}} :</label>
                                    <input type="password" name="password" class="form-control" required>
                                </div>
                                <div class="col-md-12">
                                    <label>{{__('Confirm Password')}} :</label>
                                    <input type="password" name="password_confirmation" class="form-control" required>
                                </div>
                                <div class="col-12 text-center mt-3 mb-3">
                                    <button type="submit" class="btn btn-base border-radius-5 w-100">{{__('Submit')}}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{asset('assets/frontend/deepblue/js/countryWiseCity.js')}}"></script>
@endsection
