@extends($theme.'frontend.layouts.master')
@section('title',__('Support'))
@section('content')

<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-3">
                <h4 class="card-title mb-0">{{__('Support Ticket')}}</h4>
                <a href="{{route('customer.new.ticket')}}" class="btn btn-md hn_btn_solid float-end"><i class="fa fa-plus"></i> @lang('New Tickets')</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table site-table">
                        <thead>
                            <tr>
                                <th>{{__('Sl')}}</th>
                                <th>{{__('Ticket Id')}}</th>
                                <th>{{__('Subject')}}</th>
                                <th>{{__('Raised Time')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($all_support as $key=>$data)
                        <tr>
                            <td data-caption="{{__('Sl')}}">{{$key+1}}</td>
                            <td data-caption="{{__('Ticket Id')}}">{{$data->ticket}}</td>
                            <td data-caption="{{__('Subject')}}">{{$data->subject}}</td>
                            <td data-caption="{{__('Raised Time')}}">{{$data->created_at->format('F dS, Y')}}</td>
                            <td data-caption="{{__('Status')}}">
                                @if($data->status == 1)
                                    <span class="badge bg-warning">{{__('Opened')}}</span>
                                @elseif($data->status == 2)
                                    <span class="badge bg-success">{{__('Answered')}}</span>
                                @elseif($data->status == 3)
                                    <span class="badge bg-info"> {{__('User Reply')}} </span>
                                @elseif($data->status == 9)
                                    <span class="badge bg-danger">  {{__('Closed')}} </span>
                                @endif
                            </td>
                            <td data-caption="{{__('Action')}}">
                                <a class="btn btn-base btn-sm" href="{{route('ticket.customer.reply', $data->ticket )}}"><b>{{__('View')}}</b></a>
                            </td>
                        </tr>
                        @empty 
                        <tr>
                            <td colspan="6" class="text-center">
                                <div class="no-data-found">
                                    <span class="icon"><i class="far fa-folder-open"></i></span>
                                    <p class="mb-0">{{__('No Data Found')}}</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@stop