@extends($theme.'frontend.layouts.master')
@section('title',__('Support Reply'))
@section('content')

<div class="blog-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                        <h5 class="card-title mb-0">#{{$ticket_object->ticket}} - {{$ticket_object->subject}}</h5>
                        <div>
                            @if($ticket_object->status == 1)
                            <button class="btn btn-warning btn-sm pull-end"> {{__('Opened')}}</button>
                            @elseif($ticket_object->status == 2)
                            <button type="button" class="btn btn-success btn-sm pull-end">  {{__('Answered')}} </button>
                            @elseif($ticket_object->status == 3)
                            <button type="button" class="btn btn-info btn-sm pull-end"> {{__('Customer Reply')}} </button>
                            @elseif($ticket_object->status == 9)
                            <button type="button" class="btn btn-danger btn-sm pull-end">  {{__('Closed')}} </button>
                            @endif
                            <a href="{{route('ticket.close', $ticket_object->ticket)}}" class="btn btn-danger btn-sm pull-end make-close-support">{{__('Make to Close')}}</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <ul class="list-style-none p-0 m-0">
                            @foreach($ticket_data as $data)
                            <li class="bg-light p-4 mb-4">
                                <p class="d-flex flex-wrap align-items-center justify-content-between border-bottom pb-2">
                                    <span class="fw-semibold">
                                        @if($data->type == 1)
                                            {{$ticket_object->user_member->name}}
                                        @elseif($data->type == 0)
                                            {{__('Admin')}}
                                        @endif
                                    </span>
                                    <span class="text-muted">{{$data->updated_at->format('d M, Y - h:i A') }}</span>
                                </p>
                                <div class="comment-content">
                                    <p>{!! $data->comment !!}</p>
                                </div>  
                            </li>
                            @endforeach
                        </ul>
                        <form method="POST" class="mt-4" action="{{route('store.customer.reply', $ticket_object->ticket)}}" accept-charset="UTF-8" class="form-horizontal form-bordered">
                            @csrf
                            <h4 class="mb-3">{{__('Leave a Reply')}}</h4>
                            <textarea placeholder="Message" name="comment" class="form-control"></textarea>
                            <button type="submit" class="btn btn-base border-radius-5 mt-4">{{__('Post Comment')}}</button>
                        </form> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection