@extends($theme.'frontend.layouts.master')
@section('title',__('Wallets'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="card mb-4">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{__('WALLET ADDRESSES')}}</h4>
                <div class="d-inline-flex align-items-center gap-2">
                    <a href="#addwallet" data-bs-toggle="modal" class="btn btn-base btn-sm float-end"><i class="fa fa-plus"></i> @lang('New Wallet')</a>
                    <a href="#addwalletsend" data-bs-toggle="modal" class="btn btn-primary wallet-cust m-0 btn-sm"><i class="fa fa-upload" aria-hidden="true"></i> @lang('Send')</a>
                    <a href="#addwalletreceived" data-bs-toggle="modal" class="btn btn-info btn-sm text-white"><i class="fa fa-download" aria-hidden="true"></i> @lang('Receive')</a>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table site-table">
                        <thead>
                            <tr>
                                <th>{{__('Name')}}</th>
                                <th>{{__('Wallet Address')}}</th>
                                <th>{{__('Balance')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse ($wallet as $item)
                        <tr>
                            <td data-caption="{{__('Name')}}">{{$item->wallet_name}}</td>
                            <td data-caption="{{__('Wallet Address')}}">{{$item->address}}</td>
                            <td data-caption="{{__('Balance')}}">{{number_format($item->balance,8)}} {{$general->cp_currency}}</td>
                        </tr>
                        
                        @empty 
                        <tr>
                            <td colspan="6" class="text-center">
                                <div class="no-data-found">
                                    <span class="icon"><i class="far fa-folder-open"></i></span>
                                    <p class="mb-0">{{__('No Data Found')}}</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addwallet" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle">{{__('Create New Wallet')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{route('new-wallet.store')}}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group">
                            <label class="text-white" for="investAmount">{{__('Wallet Name')}}</label>
                            <input type="text" class="form-control" id="investAmount" name="wallet_name" placeholder="{{__('Optional.Eg: My Wallet')}}" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">{{__('Submit')}}</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="addwalletsend" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle">{{__('Send')}} {{$general->cp_currency}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="purPlanTwo" action="{{route('purchase-coin-send.store')}}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group mb-2">
                        <label class="text-white">{{__('Send From')}}</label>
                        <select class="form-select" aria-label="Default select example" name="from_wallet_id" id="fromad">
                        @foreach ($wallet as $item)
                            <option value="{{$item->id}}">{{$item->wallet_name}} | {{$item->address}} | {{$item->balance}} {{$general->cp_currency}}</option>
                        @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white">{{__('To')}}</label>
                        <input type="text" name="to_wallet_id" id="toadd" class="form-control input-sz" placeholder="Enter Recipient Wallet Address" required="">
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white">{{__('Amount')}}</label>
                        <div class="input-group">
                            <input type="text" name="coin_amount" class="form-control" id="amount" required>
                            <span class="input-group-text" id="basic-addon2">{{$general->cp_currency}}</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">{{__('Send')}}</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addwalletreceived" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle">{{__('Receive')}} {{$general->cp_currency}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="purPlanTwo" action="{{route('purchase-coin-receive.store')}}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group mb-2">
                        <label class="text-white">{{__('Sender Wallet Address')}}</label>
                        <input type="text" name="to_wallet_id" id="toadd" class="form-control input-sz" placeholder="Enter Recipient Wallet Address" required="">
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white">{{__('Receive Wallet Address')}}</label>
                        <select class="form-select" aria-label="Default select example" name="from_wallet_id" id="fromad">
                            @foreach ($wallet as $item)
                            <option value="{{$item->id}}">{{$item->wallet_name}} | {{$item->address}} | {{$item->balance}} {{$general->cp_currency}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-2">
                    <label class="text-white">{{__('Amount')}}</label>
                        <div class="input-group">
                            <input type="text" name="coin_amount" class="form-control" id="amount" required>
                            <span class="input-group-text" id="basic-addon2">{{$general->cp_currency}}</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">{{__('Submit')}}</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
