@extends($theme.'frontend.layouts.master')
@section('title',__('Withdraw History'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">{{__('Withdraw Logs')}}</h4>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table site-table">
                        <thead>
                            <tr>
                                <th>{{__('Gateway Name')}}</th>
                                <th>{{__('Amount')}}</th>
                                <th>{{__('Charge')}}</th>
                                <th>{{__('Method Cur Amount')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Transaction ID')}}</th>
                                <th>{{__('Time')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($deposits as $deposit)
                            <tr>
                                <td data-caption="Email">{{__($deposit->method_name)}}</td>
                                <td data-caption="Username">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                                <td data-caption="Mobile">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                                <td data-caption="Balance">{{round($deposit->amount*$deposit->method_rate, 8)}} {{$deposit->method_cur}}</td>
                                @if($deposit->status == 0)
                                    <td data-caption="Balance"><span class="badge bg-warning text-dark">{{__('pending')}}</span></td>
                                @elseif($deposit->status == 1)
                                    <td data-caption="Balance"><span class="badge bg-success">{{__('complete')}}</span></td>
                                @else
                                    <td data-caption="Balance"><span class="badge bg-danger">{{__('rejected')}}</span></td>
                                @endif
                                <td  data-caption="Details">{{$deposit->withdraw_id}}</td>
                                <td  data-caption="Time">{{$deposit->updated_at->format('d/m/y  h:i A')}}</td>
                            </tr>
                            @empty 
                            <tr>
                                <td colspan="6" class="text-center">
                                    <div class="no-data-found">
                                        <span class="icon"><i class="far fa-folder-open"></i></span>
                                        <p class="mb-0">{{__('No Data Found')}}</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                    <div class="row">
                        <div class="col-md-12 text-center">
                            {{$deposits->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
