@extends($theme.'frontend.layouts.master')
@section('title', __('Withdraw Preview'))
@section('content')
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="{{route('confirm.withdraw.store')}}" enctype="multipart/form-data">
                        {{csrf_field()}}
                        @php
                            $charge = ((floatval($amount) * floatval($method->chargepc))/100) + floatval($amount) + floatval($method->chargefx);
                        @endphp
                        <input type="hidden" name="amount" value="{{$amount}}" >
                        <input type="hidden" name="method_id" value="{{$method->id}}" >
                            <div class="row gy-4 justify-content-center">
                                <div class="col-xl-4 col-md-6">
                                    <div class="thumb mb-4 align-self-center">
                                        <img src="{{asset('assets/images/withdraw_methods/'.$method->image)}}" alt="icon">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="facility-details">
                                        <ul class="list-group mb-4">
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span>{{__('Request for Withdraw Amount')}}:</span>
                                                <span><strong>{{$amount}}</strong> {{$general->currency}}</span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span>{{__('Charge')}} :</span>
                                                <span class="text-danger"><strong>{{((floatval($amount) * floatval($method->chargepc))/100)+ floatval($method->chargefx)}}</strong> {{$general->currency}} | ({{$method->chargepc}} % + {{$method->chargefx}} {{$general->currency}})</span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span>{{__('Total Amount Deduct')}}:</span>
                                                <span><strong>{{$charge}}</strong> {{$general->currency}}</span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span>{{__('In')}} {{$method->currency}}:</span>
                                                <span><strong>{{round($amount*$method->rate, 4)}}</strong> {{$method->currency}}</span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span>{{__('Payment Gateway')}}:</span>
                                                <span class="text-primary"><strong>{{$method->name}}</strong></span>
                                            </li>
                                        </ul>
                                        <div class="row manual-row gy-3">
                                            
                                        </div>
                                    </div>
                                    <div class="col-12 text-center mt-3 mb-3">
                                        <input type="submit" class="btn btn-base border-radius-5 pe-5 ps-5" id="btn-confirm" value="{{__('Confirm Withdraw')}}">
                                    </div>
                                </div>
                            </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')
<script>
    var globalData;
    $(document).ready(function() {

        "use strict"
        $('.manual-row').empty();
        var code = {{$method->id}};
        var url = '{{ route("user.withdraw.gateway",":code") }}';
        url = url.replace(':code', code);
        $.get(url, function (data) {
            globalData = data;
            if (data.credentials !== undefined) {
                $('.manual-row').append(data.credentials)

            }

        });

    });
</script>
@endsection
