@extends($theme.'frontend.layouts.master')
@section('title',__('Home'))
@section('content')
    
<section class="features-section">
    <div class="container-fluid">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="item active">
                        <div class="icon">
                            <img src="{{asset('assets/images/work/'.$workAreaFirst->icon)}}" alt="img">
                        </div>
                        <h4>{{__($workAreaFirst->title)}}</h4>
                        <p>{{__(short_text($workAreaFirst->description,25))}}</p>
                        <a href="{{route('single.page',['class' => 'work','id'=>$workAreaFirst->id])}}">{{__('Read more')}}</a>
                    </div>
                </div>
                @foreach($workArea as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="item active">
                        <div class="icon">
                            <img src="{{asset('assets/images/work/'.$data->icon)}}" alt="img">
                        </div>
                        <h4>{{__($data->title)}}</h4>
                        <p>{{__(short_text($data->description,25))}}</p>
                        <a href="{{route('single.page',['class' => 'work','id'=>$data->id])}}">{{__('Read more')}}</a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>


<section class="about-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="left-content">
                    <div class="heading-title">
                        <h6><span></span> {{__($general->about_head)}}</h6>
                            <h2>{{__($general->about_title)}}</h2>
                            <p>{{__($general->about_body)}}</p>
                    </div>
                    <div class="media">
                        <div class="images">
                            <img src="{{asset('assets/images/about/one.png')}}" alt="img">
                        </div>
                        <div class="media-body">
                            <h3><a href="{{route('single.page',['class' => 'about_one'])}}">{{__($general->single_about1_title)}}</a></h3>
                            <p>{{__(short_text($general->single_about1_description, 20))}}</p>
                        </div>
                    </div>
                    <div class="media">
                        <div class="images">
                            <img src="{{asset('assets/images/about/two.png')}}" alt="img">
                        </div>
                        <div class="media-body">
                            <h3><a href="{{route('single.page',['class' => 'about_two',])}}">{{__($general->single_about2_title)}}</a></h3>
                            <p>{{__(short_text($workAreaFirst->description,25))}}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="right-side">
                    <img src="{{asset('assets/images/about/about_right_img.png')}}" alt="img">
                </div>
            </div>
        </div>
    </div>
</section>

 <section class="how-we-work-section">
    <div class="container">
        <div class="heading-title">
            <h6><span></span> {{__('How we work')}}</h6>
            <h2>{{__('How It Works')}}</h2>
        </div>
        <div class="row">
            @foreach($services as $key => $data)
            <div class="col-md-4">
                <div class="item">
                    <div class="icon icon-{{$key+1}}">
                        <img src="{{asset('assets/images/service/'.$data->icon)}}" alt="img">
                        <span>{{$key+1}}</span>
                    </div>
                    <h3>{{__($data->title)}}</h3>
                    <p>{{__($data->description)}}</p>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>


<section class="pricing-section">
    <div class="container">
        <div class="heading-title">
            <h6><span></span> {{__($general->invest_head)}}</h6>
            <h2>{{__($general->invest_title)}}</h2>
            <p>{{__($general->invest_description)}}</p>
        </div>
        <ul class="nav nav-pills" id="pills-tab1" role="tablist">
            @if(count($roi_plans))
            <li class="nav-item" role="presentation">
              <button class="active" id="pills-home-tab1" data-bs-toggle="pill" data-bs-target="#nav-roi" type="button">{{__('ROI Investment')}}</button>
            </li>
            @endif
            @if(count($fixed_plans))
            <li class="nav-item" role="presentation">
              <button class=" " id="pills-profile-tab2" data-bs-toggle="pill" data-bs-target="#nav-fixed" type="button">{{__('Fixed Investment')}}</button>
            </li>
            @endif
        </ul>
          <div class="tab-content" id="pills-tabContent1">
            <div class="tab-pane fade show active" id="nav-roi" style="overflow: visible;">
                <div class="row">
                    @foreach($roi_plans as $data)
                    <div class="col-lg-4">
                        <div class="pracing-item ">
                            <div class="top-left">
                                <p>{{__($data->percent)}}%</p>
                            </div>
                            <div class="top-area">
                                <img src="{{url('/')}}/assets/frontend/violet/img/pricing/01.png" alt="img">
                                <p>{{__($data->name)}}</p>
                            </div>
                            <ul>
                                <li><span><i class="fal fa-check"></i></span>{{__('Minimum Deposit')}} {{$data->min_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Maximum Deposit')}} {{$data->max_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Capital Return')}} @if($data->capital_back_status == 1) 
                                    <span class="badge bg-pill bg-danger">@lang('Off')</span> @else <span class="badge bg-pill bg-success">@lang('On')</span> @endif
                                </li>
                                <li><span><i class="fal fa-check"></i></span>{{$data->percent}}% {{__('Payback')}}
                                    @switch($data->period)
                                        @case(1)
                                        {{__('Hourly')}}
                                        @break
                                        @case(24)
                                        {{__('Daily')}}   @break
                                        @case(168)
                                        {{__('Weekly')}}   @break
                                        @case(720)
                                        {{__('Monthly')}}   @break
                                        @case(2880)
                                        {{__('Quarterly')}}   @break
                                        @case(8640)
                                        {{__('Yearly')}}   @break
                                    @endswitch</li>
                            </ul>
                            <a href="{{route('invest.index')}}" class="buy-now">{{__('Buy Now')}}</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <div class="tab-pane fade" id="nav-fixed" style="overflow: visible;">
                <div class="row">
                    @foreach($fixed_plans as $data)
                    <div class="col-lg-4">
                        <div class="pracing-item ">
                            <div class="top-left">
                                <p>{{__($data->percent)}}%</p>
                            </div>
                            <div class="top-area">
                                <img src="{{url('/')}}/assets/frontend/violet/img/pricing/01.png" alt="img">
                                <p>{{__($data->name)}}</p>
                            </div>
                            <ul>
                                <li><span><i class="fal fa-check"></i></span>{{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('ROI Action Lifetime TIMES')}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Capital Return')}} @if($data->capital_back_status == 1) 
                                    <span class="badge bg-pill bg-danger">@lang('Off')</span> @else <span class="badge bg-pill bg-success">@lang('On')</span> @endif
                                </li>
                                <li><span><i class="fal fa-check"></i></span>{{$data->percent}}% {{__('Payback')}}
                                    @switch($data->period)
                                        @case(1)
                                        {{__('Hourly')}}
                                        @break
                                        @case(24)
                                        {{__('Daily')}}   @break
                                        @case(168)
                                        {{__('Weekly')}}   @break
                                        @case(720)
                                        {{__('Monthly')}}   @break
                                        @case(2880)
                                        {{__('Quarterly')}}   @break
                                        @case(8640)
                                        {{__('Yearly')}}   @break
                                    @endswitch</li>
                            </ul>
                            <a href="{{route('invest.index')}}" class="buy-now">{{__('Buy Now')}}</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            
          </div>
    </div>
</section>

<section class="calculate-section">
    <div class="container">
        <div class="calculate_wraper">
            <div class="row g-0">
                <div class="col-lg-7">
                    <div class="left_content">
                        <h4>{{__('Calculate Your Profit')}}</h4>
                        <form class="purPlan">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="input-group">
                                        <label for="one">{{__('Mining Plan Type')}}</label>
                                        <select class="form-select top-select" id="planType" data-all="{{$data}}">
                                            <option selected disabled>{{__('Select Plan Type')}}</option>
                                            <option value="0">{{$general->currency}}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-8 normalInvest">
                                    <div class="input-group">
                                        <label for="one">{{__('Choose Mining Plan')}}</label>
                                        <select class="form-select top-select  planSelect">
                                            <option selected disabled>{{__('Select Plan')}}</option>
                                            @foreach ($roi_plans as $data)
                                            <option value="{{$data->id}}" planDetail="{{$data}}">{{$data->name}} - @switch($data->period)
                                                @case(1)
                                                {{__('Hourly')}} @break
                                                @case(24)
                                                {{__('Daily')}} @break
                                                @case(168)
                                                {{__('Weekly')}} @break
                                                @case(720)
                                                {{__('Monthly')}} @break
                                                @case(2880)
                                                {{__('Quarterly')}} @break
                                                @case(8640)
                                                {{__('Yearly')}} @break
                                            @endswitch for {{__('Min')}} {{$data->min_amount}} {{$general->currency}} - {{__('Max')}}  {{$data->max_amount}} {{$general->currency}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <label for="two">{{__('Enter Amount')}}</label>
                                        <span class="input-group-text" id="basic-addon1">{{$general->currency}}</span>
                                        <input type="number" class="form-control" id="investAmount" name="invest_amount" placeholder="Amount">
                                    </div>
                                </div>
                            </div>
                            <button type="button" style="display: block !important" class="theme_btn subBtn">Calculate</button>
                        </form>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="right_side row g-0">
                        <div class="col-6">
                            <div class="item item_first">
                                <img src="{{asset('assets/frontend/violet/images/search.svg')}}" alt="img">
                                <p>{{__('Total Percent')}}</p>
                                <h2 class="roiPerc">0</h2>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="item">
                                <img src="{{asset('assets/frontend/violet/images/001.svg')}}" alt="img">
                                <p>{{__('Return Action')}}</p>
                                <h2 class="roiAction">0</h2>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="item item_first">
                                <img src="{{asset('assets/frontend/violet/images/0002.svg')}}" alt="img">
                                <p>{{__('Net Profit')}}</p>
                                <h2 class="roiMsg">0 </h2>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="item">
                                <img src="{{asset('assets/frontend/violet/images/003.svg')}}" alt="img">
                                <p>{{__('Total Return')}}</p>
                                <h2 class="totalGetAmount">0</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="top-investor-section">
    <div class="container">
        <div class="heading-title">
            <h6><span></span> {{__($general->investor_head)}}</h6>
            <h2>{{__($general->investor_title)}}</h2>
            <p>{{__($general->investor_description)}}</p>
        </div>
        <div class="row">
            @foreach($investors as $data)
            <div class="col-lg-3 col-sm-6">
                <div class="investor-item">
                    <div class="card">
                        <div class="images">
                            <img src="{{asset('assets/images/investor/'.$data->image)}}" alt="img">
                        </div>
                        <div class="card-body">
                            <h3>{{__($data->name)}}</h3>
                            <p>{{__($data->designation)}}</p>
                            <ul>
                                @if(!is_null($data->fb_link))
                                <li><a href="{{$data->fb_link}}"><i class="fab fa-facebook-f"></i></a></li>
                                @endif
                                @if(!is_null($data->twitter_link))
                                <li ><a href="{{$data->twitter_link}}"><i class="fab fa-twitter"></i></a></li>
                                @endif
                                @if(!is_null($data->linkedin_link))
                                <li><a href="{{$data->linkedin_link}}"><i class="fab fa-linkedin-in"></i></a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<section class="testimonials-section">
    <div class="container">
        <div class="heading-title">
            <h2>{{__('Latest Top Investments News')}}</h2>
        </div>
        <div class="row">
            @foreach($news as $data)
            <div class="col-lg-4 col-md-6">
                <div class="item active">
                    <div class="icon">
                        <img src="{{asset('assets/images/news/'.$data->image)}}" alt="img">
                    </div>
                    <h4>{{$data->title}}</h4>
                    <span><i class="fa fa-user"></i>{{__('Author')}}</span>
                    <span><i class="fa fa-clock-o"></i>{{date('F j, Y', strtotime($data->updated_at))}}</span>
                    <p>{!! short_text($data->description, 30) !!}</p>
                    <a href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{__('Read More')}}</a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section> 

<section class="brand-section">
    <div class="container">
        <div class="heading-title">
            <h2>{{__('Trusted By')}}</h2>
        </div>
        <div class="brand-slider owl-carousel">
            @foreach ($partners as $data)
                <div class="item">
                    <img src="{{ asset('assets/images/partner/'.$data->image)}}" alt="img">
                </div>
            @endforeach
        </div>
    </div>
</section>

    <input type="hidden" value="{{$general->cp_currency}}" id="cp_currency">
    <input type="hidden" value="{{$general->currency}}" id="currency">
@stop