<header class="main-header">
    <div class="container">
        <div class="top-header">
            <div class="row">
                <div class="col-md-5">
                    <ul class="topbar-left">
                        <li><a href="mailto:{{$general->contact_email}}" target="_blank"><span><i class="fa fa-envelope"></i></span> {{$general->contact_email}}</a></li>
                        <li><a href="tel:{{$general->contact_phone}}"><span class="phone"><i class="fa fa-phone"></i></span>{{$general->contact_phone}}</a></li>
                    </ul>
                </div>
                <div class="col-md-7">
                    <ul class="topbar-right">
                        <li></li>
                        @foreach($social as $data)
                            <li><a href="{{$data->link}}"><i class="fab fa-{{$data->icon}}"></i></a></li>
                        @endforeach
                        <li>
                            <select class="form-select" aria-label="Default select example" id="langSel">
                                <option value="en">English</option>
                                @foreach($lang as $data)
                                <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
                                @endforeach
                            </select>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <nav class="main-navbar">
            <div class="nav-inner">
                <a href="{{url('/')}}" class="brand"><img class="logo-resize" src="{{asset('assets/images/logo/logo.png')}}" alt="img"></a>
                <ul class="desktop-menu">
                    @auth
                    <li><a class="@if(request()->path() == 'home') active @endif" href="{{route('home')}}">{{__('Dashboard')}}</a></li>
                    @if ($general->ico == 1)
                    <li><a href="">{{$general->cp_currency}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('wallet.index')}}"><i class="fal fa-chevron-right"></i>{{__('Wallets')}}</a></li>
                            <li><a href="{{route('my.wallet.transaction.log')}}"><i class="fal fa-chevron-right"></i>{{__('My Transaction Log')}}</a></li>
                            <li><a href="{{route('other.wallet.transaction.log')}}"><i class="fal fa-chevron-right"></i>{{__('Other Transaction Log')}}</a></li>
                        </ul>
                    </li>
                    @endif
                    <li><a href="">{{__('Deposit')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('users.showDepositMethods')}}"><i class="fal fa-chevron-right"></i>{{__('Add Deposit')}}</a></li>
                            <li><a href="{{route('user.deposit.log')}}"><i class="fal fa-chevron-right"></i>{{__('Deposit Log')}}</a></li>
                        </ul>
                    </li>
                    <li><a href="">{{__('Investment')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('invest.index')}}"><i class="fal fa-chevron-right"></i>{{__('Investment Plan')}}</a></li>
                            <li><a href="{{route('invest.log')}}"><i class="fal fa-chevron-right"></i>{{__('Invest Log')}}</a></li>
                        </ul>
                    </li>

                    <li class="">
                        <a href="{{route('credit-card')}}">{{__('Credit Card')}}</a>
                    </li>
                    
                    <li><a href="">{{__('Transaction')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('user.ref.index')}}"><i class="fal fa-chevron-right"></i>{{__('My Referral Tree')}}</a></li>
                            <li><a href="{{route('fund.transfer')}}"><i class="fal fa-chevron-right"></i>{{__('Fund Transfer')}}</a></li>
                            <li><a href="{{route('transaction.log')}}"><i class="fal fa-chevron-right"></i>{{__('Transaction Log')}}</a></li>
                            @if ($general->ico == 1)
                                <li><a href="{{route('purchase.coin')}}"><i class="fal fa-chevron-right"></i>{{__('MIN CRYPTO')}}</a></li>
                            @endif
                        </ul>
                    </li>
                    <li><a href="">{{__('Withdraw')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('user.withdraw.method')}}"><i class="fal fa-chevron-right"></i>{{__('Withdraw')}}</a></li>
                            <li><a href="{{route('user.withdraw.log')}}"><i class="fal fa-chevron-right"></i>{{__('Withdraw Log')}}</a></li>
                        </ul>
                    </li>
                    @php $check_count = \App\Models\Support::where('status', 1)->get() @endphp
                    <li><a href="#">{{split_name(auth()->user()->name)[0]}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('profile.index')}}"><i class="fal fa-chevron-right"></i>{{__('Profile')}}</a></li>
                            <li><a href="{{route('user.kyc.index')}}"><i class="fal fa-chevron-right"></i>{{__('Kyc')}}</a></li>
                            <li><a href="{{route('two.factor.index')}}"><i class="fal fa-chevron-right"></i>{{__('Security')}}</a></li>
                            <li><a href="{{route('customer.support.index')}}"><i class="fal fa-chevron-right"></i>{{__('Support')}} @if(count($check_count) == 0)  @else <span class="right badge bg-danger"> {{count($check_count)}} </span> @endif</a></li>
                            <li><a onclick="event.preventDefault();document.getElementById('logout-form').submit();" href="{{route('logout')}}"><i class="fal fa-chevron-right"></i>{{__('Logout')}}</a></li>
                        </ul>
                    </li>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                        @csrf
                    </form>
                    @else
                    <li><a class="active" href="{{url('/')}}">{{__('Home')}}</a></li>
                    @foreach($frontMenu as $data)
                        <li><a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a></li>
                    @endforeach
                    <li>
                        <a href="{{route('news.index')}}">{{__('News')}}</a>
                    </li>
                    <li>
                        <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
                    </li>
                    <li><a href="#">{{__('Account')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{route('register')}}"><i class="fal fa-chevron-right"></i>{{__('Sign Up')}}</a></li>
                            <li><a href="{{route('login')}}"><i class="fal fa-chevron-right"></i>{{__('Sign In')}}</a></li>
                        </ul>
                    </li>
                    @endif
                </ul>
                <div class="mobile-header">
                    <div class="menu-icon">
                        <div class="open-menu"><i class="far fa-bars"></i></div>
                        <div class="close-menu"><i class="far fa-times"></i></div>
                    </div>
                </div>
            </div>
        </nav>
        <div class="mobile-menu overflow-auto dropdown">
            <ul>
                @auth
                @if ($general->ico == 1)
                    <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Ico" role="button" aria-expanded="false" aria-controls="collapseExample">{{$general->cp_currency}}</a>
                        <ul class="collapse" id="Ico">
                            <li><a href="{{route('wallet.index')}}"><i class="fal fa-chevron-right"></i>{{__('Wallets')}}</a></li>
                            <li><a href="{{route('my.wallet.transaction.log')}}"><i class="fal fa-chevron-right"></i>{{__('My Transaction Log')}}</a></li>
                            <li><a href="{{route('other.wallet.transaction.log')}}"><i class="fal fa-chevron-right"></i>{{__('Other Transaction Log')}}</a></li>
                        </ul>
                    </li>
                @endif
                <li><a class="active" href="{{route('home')}}">{{__('Dashboard')}}</a></li>
                <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Deposit" role="button" aria-expanded="false" aria-controls="collapseExample">{{__('Deposit')}}</a>
                    <ul class="collapse" id="Deposit">
                        <li><a href="{{route('users.showDepositMethods')}}"><i class="fal fa-chevron-right"></i>  {{__('Add Deposit')}}</a></li>
                        <li><a href="{{route('user.deposit.log')}}"><i class="fal fa-chevron-right"></i>  {{__('Deposit Log')}}</a></li>
                    </ul>
                </li>
                <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Investment" role="button" aria-expanded="false" aria-controls="collapseExample">{{__('Investment')}}</a>
                    <ul class="collapse" id="Investment">
                        <li><a href="{{route('invest.index')}}"><i class="fal fa-chevron-right"></i>  {{__('Investment Plan')}}</a></li>
                        <li><a href="{{route('invest.log')}}"><i class="fal fa-chevron-right"></i>  {{__('Invest Log')}}</a></li>
                    </ul>
                </li>

                <li class="">
                    <a href="{{route('credit-card')}}">{{__('Credit Card')}}</a>
                </li>


                <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Transaction" role="button" aria-expanded="false" aria-controls="collapseExample">{{__('Transaction')}}</a>
                    <ul class="collapse" id="Transaction">
                        <li><a href="{{route('user.ref.index')}}"><i class="fal fa-chevron-right"></i>  {{__('My Referral Tree')}}</a></li>
                        <li><a href="{{route('fund.transfer')}}"><i class="fal fa-chevron-right"></i>  {{__('Fund Transfer')}}</a></li>
                        <li><a href="{{route('transaction.log')}}"><i class="fal fa-chevron-right"></i>  {{__('Transaction Log')}}</a></li>
                        @if ($general->ico == 1)
                            <li><a href="{{route('purchase.coin')}}"><i class="fal fa-chevron-right"></i>{{__('MIN CRYPTO')}}</a></li>
                        @endif
                    </ul>
                </li>
                <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Withdraw" role="button" aria-expanded="false" aria-controls="collapseExample">{{__('Withdraw')}}</a>
                    <ul class="collapse" id="Withdraw">
                        <li><a href="{{route('user.withdraw.method')}}"><i class="fal fa-chevron-right"></i>  {{__('Withdraw')}}</a></li>
                        <li><a href="{{route('user.withdraw.log')}}"><i class="fal fa-chevron-right"></i>  {{__('Withdraw Log')}}</a></li>
                    </ul>
                </li>
                <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#profile" role="button" aria-expanded="false" aria-controls="collapseExample">{{split_name(auth()->user()->name)[0]}}</a>
                    <ul class="collapse" id="profile">
                        <li><a href="{{route('profile.index')}}"><i class="fal fa-chevron-right"></i>  {{__('Profile')}}</a></li>
                        <li><a href="{{route('two.factor.index')}}"><i class="fal fa-chevron-right"></i>  {{__('Security')}}</a></li>
                        <li><a onclick="event.preventDefault();document.getElementById('logout-form').submit();" href="{{route('logout')}}"><i class="fal fa-chevron-right"></i>  {{__('Logout')}}</a></li>
                    </ul>
                </li>
                @else
                    <li><a class="active" href="{{url('/')}}">{{__('Home')}}</a></li>
                    @foreach($frontMenu as $data)
                    <li><a href="{{route('single.page',['class' => 'Menu', 'id' =>$data->id])}}">{{__($data->title)}}</a></li>
                    @endforeach
                    <li>
                        <a href="{{route('news.index')}}">{{__('News')}}</a>
                    </li>
                    <li>
                        <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
                    </li>
                    <li><a class="dropdown-toggle" data-bs-toggle="collapse" href="#Account" role="button" aria-expanded="false" aria-controls="collapseExample">{{__('Account')}}</a>
                        <ul class="collapse" id="Account">
                            <li><a href="{{route('register')}}"><i class="fal fa-chevron-right"></i> {{__('Sign Up')}}</a></li>
                            <li><a href="{{route('login')}}"><i class="fal fa-chevron-right"></i> {{__('Sign In')}}</a></li>
                        </ul>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</header>