@extends($theme.'frontend.layouts.master')
@section('title',__('News'))
@section('content')
<section class="features-section">
    <div class="container-fluid">
        <div class="container">
            <div class="row">
                @foreach($news as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="item active">
                        <div class="icon">
                            <img src="{{asset('assets/images/news/'.$data->image)}}" alt="img">
                        </div>
                        <h4>{{$data->title}}</h4>
                        <span><i class="fa fa-user"></i>{{__('Author')}}</span>
                        <span><i class="fa fa-clock-o"></i>{{date('F j, Y', strtotime($data->updated_at))}}</span>
                        <p>{!! short_text($data->description, 30) !!}</p>
                        <a href="{{route('single.page',['class' => 'News', 'id' =>$data->id])}}">{{__('Read More')}}</a>
                    </div>
                </div>
                @endforeach
                <div class="col-lg-12 text-center">
                    {{$news->links()}}
                </div>
            </div>
        </div>
    </div>
</section>
@stop