@extends($theme.'frontend.layouts.master')
@section('title',__(isset($title) ? $title: 'Single Page'))
@section('content')
<section class="blog-section blog-details-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="left-side">
                    <div class="card">
                        <div class="images">
                            @isset($image)
                            <img src="{{$image}}" alt="img">
                            @endif
                            @isset($updated_at)
                            <div class="bottom_text">
                                <h5>{{date('d',strtotime($updated_at))}} <span>{{date('M',strtotime($updated_at))}}</span></h5>
                            </div>
                            @endif
                        </div>
                        <div class="card-body">
                            @isset($description)
                            <p>{!! $description !!}</p>
                            @endif
                            <ul class="tags_one">
                                <li><span>{{__('Share')}}:</span></li>
                                <li><a href="https://www.facebook.com/sharer/sharer.php?u={{urlencode(url()->current()) }}" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                                <li><a href="https://twitter.com/intent/tweet?text=my share text&amp;url={{urlencode(url()->current()) }}" target="_blank"><i class="fab fa-twitter"></i></a></li>
                                <li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{urlencode(url()->current()) }}&amp;title=my share text&amp;summary=dit is de linkedin summary" target="_blank"><i class="fab fa-linkedin"></i></a></li>
                                <li><a href="https://plus.google.com/share?url={{urlencode(url()->current()) }}" target="_blank"><i class="fab fa-google-plus"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="comment">
                        <div id="fb-root"></div>
                        <script>(function(d, s, id) {
                                var js, fjs = d.getElementsByTagName(s)[0];
                                if (d.getElementById(id)) return;
                                js = d.createElement(s); js.id = id;
                                js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.8&appId=1421567158073949";
                                fjs.parentNode.insertBefore(js, fjs);
                            }(document, 'script', 'facebook-jssdk'));
                        </script>
                        <div class="fb-comments" data-href="{{ url()->current() }}" data-width="100%" data-numposts="5"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="right-side">
                    <div class="about-me">
                        <h3>{{__('Follow Us')}}</h3>
                        <div class="images">
                            <ul class="icon">
                                @foreach($social as $data)
                                <li><a href="{{$data->link}}" target="_blank"><i class="fab fa-{{$data->icon}}"></i></a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <div class=" about-me popular-posts">
                        <h3>{{__('Recent Posts')}}</h3>
                        @foreach($recentPost as $data)
                        <div class="media">
                            <div class="images">
                                <a href="{{route('single.page',['class' => 'news','id'=>$data->id])}}"><img src="{{asset('assets/images/news/'.$data->image)}}" alt="img"></a>
                            </div>
                            <div class="media-body">
                                <a href="{{route('single.page',['class' => 'news','id'=>$data->id])}}">{{__(short_text($data->title,5))}}</a>
                                <p>{{date('M d, Y',strtotime($data->updated_at))}}</p>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@stop