@extends($theme.'frontend.layouts.master')
@section('title',__('Login & Invest To Earn'))
@section('style')
    <link rel="stylesheet" href="{{asset('assets/frontend/violet/css/login.css')}}">
@endsection
@section('content')

<div class="container pt-5 pb-5">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="login__form">
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    @if ($general->social_api != 0)
                    <div class="social__login">
                        <a href="{{route('login.google')}}" class="btn btn__google"><i class="fab fa-google"></i> {{__('GOOGLE')}}</a>
                
                        <a href="{{route('login.facebook')}}" class="btn btn__facebook"><i class="fab fa-facebook"></i> {{__('FACEBOOK')}}</a>
                    </div>
                    <h5 class="login_devider"><span>{{__('Or sign in with')}}</span></h5>
                    @endif
                    <input type="email" name="email" class="form-control mt-5 mb-3" id="signup__email" placeholder="Email address" required autocomplete="email" autofocus/>
                    <input type="password" name="password" class="form-control mb-3" id="signup__password" placeholder="Password" required autocomplete="current-password"/>

                    @if ($general->g_captcha == 1)
                    <div class="form-group mb-3">
                        <div class="col-md-12">
                            <div class="g-recaptcha" data-sitekey="{{$general->captcha_key_one}}"></div>
                            @if ($errors->has('g-recaptcha-response'))
                                <span class="invalid-feedback" style="display: block;">
                                    <strong>{{$errors->first('g-recaptcha-response')}}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    @endif
            
                    <div class="login__options">
                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                    <label class="label-text" for="flexCheckDefault">
                        {{__('Remeber me')}}
                    </label>
            
                    <a href="{{route('user.showEmailForm')}}" class="forgot__password">{{__('Forgot your password')}}?</a>
                    </div>
            
                    <div class="form__group">
                    <button type="submit" class="btn btn__login">{{__('LOGIN')}}</button>
                    </div>
                    <div class="signup__link">
                    <span>Don't have an account? <a href="{{route('register')}}">{{__('Sign up')}}</a></span>
                    </div>
            
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
