@extends($theme.'frontend.layouts.master')
@section('title',__('Register From Here'))
@section('style')
    <link rel="stylesheet" href="{{asset('assets/frontend/violet/css/login.css')}}">
@endsection
@section('content')
<div class="container pt-5 pb-5">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="login__form">
                <form method="POST" action="{{ route('register') }}">
                    @csrf
                    @if ($general->social_api != 0)
                    <div class="social__login">
                        <a href="{{route('login.google')}}" class="btn btn__google"><i class="fab fa-google"></i> {{__('GOOGLE')}}</a>
                
                        <a href="{{route('login.facebook')}}" class="btn btn__facebook"><i class="fab fa-facebook"></i> {{__('FACEBOOK')}}</a>
                    </div>
                    <h5><span>{{__('Or sign up with')}}</span></h5>
                    @endif
                    @isset($refName)
                    <div class="form-group">
                        <label class="mt-4 mb-3">{{__('Referrer Name')}} :</label>
                        <input type="text" disabled class="form-control" value="{{$refName->name}}">
                    </div>
                    <input type="hidden" value="{{$refName->id}}" name="ref_id">
                    @endisset
                    <input type="text" name="name" class="form-control mt-4 mb-3" placeholder="Full Name" required value="{{old('name')}}" autocomplete="name" autofocus />
                    <input type="email" name="email" class="form-control mb-3" placeholder="Email address" required autocomplete="email" value="{{old('email')}}" autofocus />
                    <input type="tel" name="mobile" class="form-control mb-3" placeholder="Phone" value="{{old('mobile')}}" required />
                    <input type="password" name="password" class="form-control mb-3" placeholder="Password" required />
                    <input type="password" name="password_confirmation" class="form-control mb-3" placeholder="Confirm Password" required />

                    @if ($general->g_captcha == 1)
                    <div class="form-group mb-3">
                        <div class="col-md-12">
                            <div class="g-recaptcha" data-sitekey="{{$general->captcha_key_one}}"></div>
                            @if ($errors->has('g-recaptcha-response'))
                                <span class="invalid-feedback" style="display: block;">
                                    <strong>{{$errors->first('g-recaptcha-response')}}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    @endif
            
                    <div class="form__group">
                        <button type="submit" class="btn btn__login">{{__('Register')}}</button>
                    </div>
            
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
