@extends($theme . 'frontend.layouts.master')
@section('title', __('RazorPay'))
@section('content')
    <form action="" method="POST" id="form">

        @csrf

        <input type="hidden" name="amount" class="form-control amount" placeholder="Enter Amount"
            value="{{ number_format($data->usd_amo, 2, '.', '') }}">
        <button id="rzp-button1" data-href="{{ route('razorpay.payment.store') }}"
            class="sp_btn sp_theme_btn">{{ __('Pay Now') }}</button>

    </form>
@endsection

@section('script')

    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        $('body').on('click', '#rzp-button1', function(e) {
            e.preventDefault();
            var amount = $('.amount').val();
            var total_amount = amount * 100;
            let url = $(this).data('href');
            var options = {
                "key": "{{ $data->gateway->gateway_key_one }}",
                "amount": total_amount,
                "currency": "NGN",
                "name": "test",
                "description": "Transaction",
                "image": "test",
                "order_id": "",
                "callback_url": url,
                "prefill": {
                    "name": "{{ auth()->user()->username }}",
                    "email": "{{ auth()->user()->email }}",
                    "contact": "{{ auth()->user()->phone }}"
                },
                "notes": {
                    "address": "test test"
                },
                "theme": {
                    "color": "#9c0ac1"
                }
            };
            var rzp1 = new Razorpay(options);
            rzp1.open();
        });
    </script>
@endsection
