@extends($theme.'frontend.layouts.master')
@section('title',__('Transfer Your Balance'))
@section('content')
<div class="check-profit-area pb-5 pt-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <form method="POST" action="{{ route('transfer.store') }}">
                    @csrf
                    <div class="title text-center">
                        <h5>{{__('Share your Balance with Other User')}}</h5>
                    </div>
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <p class="text-danger"> {{$general->bal_trans_percentage_charge}}% {{__('Transfer Charge will Applied and transferred Fund will go to Secondary Balance.')}}</p>
                            <p class="text-danger"> {{$general->bal_trans_fixed_charge}} {{$general->currency}} {{__('fixed transfer Charge will Applied and transferred Fund will go to Secondary Balance.')}}</p>
                            <hr>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('Receiver Email')}} :</label>
                        <input type="email" name="email" class="form-control" placeholder="{{__('Email to Transfer')}}" required autocomplete="email" autofocus>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('Amount')}} :</label>
                        <input type="text" name="amount" class="form-control" id="amountFund" placeholder="{{__('AMOUNT YOU WANT TO SHARE')}}" autocomplete="off" required>
                        <span class="text-danger wrnMsg"></span>
                    </div>
                    <div class="form__group">
                        <button type="submit" class="btn btn__login">{{__('Transfer Now')}}</button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<input type="hidden" value="{{$general->bal_trans_fixed_charge}}" id="bal_trans_fixed_Fund">
<input type="hidden" value="{{$general->bal_trans_percentage_charge}}" id="bal_trans_percent_Fund">
<input type="hidden" value="{{$general->currency}}" id="currency_Fund">

@endsection
