@extends($theme.'frontend.layouts.master')
@section('title',__('Welcome In Home'))
@section('content')
<div class="user-panel pt-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="input-group input-referral-wrap mb-5">
                    <input type="text" class="form-control" id="myInputref"  value="{{url('/')}}/register/{{auth()->user()->referral_token}}">
                    <div class="input-group-append">
                        <button class="btn btn-secondary myrefButtonFunction" type="button" onclick="myrefButtonFunction()">{{__('Copy Referral Link')}}</button>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="row">
                    @foreach ($rankings as $rank)
                        <div class="col-xl-2 col-md-4 col-6 text-center mt-xl-0 mt-4">
                            <div class="raking-item">
                                @php
                                    $rankingIds = auth()->user()->rankings()->pluck('ranking_id')->toArray();
                                @endphp
        
                                @php
                                    $rank = \App\Models\Ranking::find($rank->id);
                                @endphp
                                @if (in_array($rank->id, $rankingIds))
                                    <img src="{{ asset('assets/images/ranking/' . $rank->image) }}" alt="">
                                    <h5 class="color-base mt-4">{{ $rank->title }}</h5>
                                    <p>{{ $rank->bonus }} {{ $general->currency }}</p>
        
                                    <p class="fs-15 text-muted"><i class="fa fa-check text-success"></i> {{ __('You are eligible for this level') }}</p>
                                @else
                                    <img src="{{ asset('assets/images/ranking/' . $rank->image) }}" alt="">
                                    <h5 class="color-base mt-4">{{ $rank->title }}</h5>
                                    <p>{{ $rank->bonus }} {{ $general->currency }}</p>
        
                                    <p class="fs-15 text-muted"><i class="fa fa-times text-danger"></i> {{ __('You are not eligible for this level') }}</p>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            
            <div class="col-lg-12">
                <div class="user-panel-wrapper">
                    <div class="row statitics-item-area mb-none-30">
                        <div class="col-lg-4">
                            <div class="statitics-item mb-30">
                                <h6 class="title">{{__('Current Balance')}}</h6>
                                <span class="stat-amount color-1">{{round(auth()->user()->balance,8)}} {{$general->currency}}</span>
                                <div class="item-shape-1"></div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="statitics-item mb-30">
                                <h6 class="title">{{__('Earning Total')}}</h6>
                                <span class="stat-amount color-2">{{round($total_earn,8)}} {{$general->currency}}</span>
                                <div class="item-shape-2"></div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="statitics-item mb-30">
                                <h6 class="title">{{__('Total Withdraw')}}</h6>
                                <span class="stat-amount color-3">{{round($total_withdraw,8)}} {{$general->currency}}</span>
                                <div class="item-shape-3"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

       

        <section class="counterup-section">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('user.deposit.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color fa fa-plus fa-3x"></i>
                                </div>
                                <h5>{{__('This Month Deposit')}}</h5>
                                <h3 ><span class="counter">{{round($month_deposit,8)}}</span></h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('invest.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color far fa-money-bill-alt fa-3x"></i>
                                </div>
                                <h5>{{__('This Month Earn')}}</h5>
                                <h3 ><span class="counter">{{round($month_earn,8)}}</span></h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('user.withdraw.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color fa fa-retweet fa-3x"></i>
                                </div>
                                <h5>{{__('This Month Withdraw')}}</h5>
                                <h3 ><span class="counter">{{round($month_withdraw,8)}}</span></h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('user.withdraw.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color fa fa-spinner fa-3x"></i>
                                </div>
                                <h5>{{__('Total Pending Withdraw')}}</h5>
                                <h3 ><span class="counter">{{round($total_PendingWithdraw,8)}}</span></h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('transaction.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color fa fa-exchange fa-3x"></i>
                                </div>
                                <h5>{{__('Total Fund Transfer')}}</h5>
                                <h3 ><span class="counter">{{round($total_fundTransfer,8)}}</span>+</h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <a href="{{route('transaction.log')}}">
                            <div class="item">
                                <div class="thumb-new">
                                    <i class="font-color fa fa-clock fa-3x"></i>
                                </div>
                                <h5>{{__('This Month Fund Transfer')}}</h5>
                                <h3 ><span class="counter">{{round($month_fundTransfer,8)}}</span></h3>{{$general->currency}}
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        
    </div>
</div>
@endsection
