@extends($theme.'frontend.layouts.master')
@section('title',__('Invest History'))
@section('content')
<div class="transaction-area left-bottom-line-bg  pt-5 pb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12">
                <div class="transaction-tab-area">
                    <div class="transaction-table tab-content">
                        <div class="tab-pane deposit-tab fade active show" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th> {{__('Package')}} </th>
                                        <th> {{__('Type')}} </th>
                                        <th> {{__('Invest Amount')}} </th>
                                        <th> {{__('Payable')}} </th>
                                        <th> {{__('Already Return')}} </th>
                                        <th> {{__('Next Return Time')}} </th>
                                        <th> {{__('Status')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($plans as $data)
                                    <tr class="table-margin">
                                        <th></th>
                                    </tr>
                                    <tr>
                                        <td>{{__($data->plan_name)}}</td>
                                        <td>
                                            @switch($data->get_period)
                                                @case(1)
                                                {{__('Hourly')}}
                                                @break
                                                @case(24)
                                                {{__('Daily')}}   @break
                                                @case(168)
                                                {{__('Weekly')}}   @break
                                                @case(720)
                                                {{__('Monthly')}}   @break
                                                @case(2880)
                                                {{__('Quarterly')}}   @break
                                                @case(8640)
                                                {{__('Yearly')}}   @break
                                            @endswitch
                                        </td>
                                        @if ($data->currency_type == 1)
                                        <td>{{$data->invest_amount}} {{$general->cp_currency}}</td>
                                        @else 
                                        <td>{{$data->invest_amount}} {{$general->currency}}</td>
                                        @endif
                                        <td>{{$data->get_percent}}%/{{is_null($data->get_action) ? 'Lifetime': $data->get_action.' Times'}}  </td>
                                        <td>{{$data->took_action}} {{__('TIMES')}}</td>
                                        <td>{{date('d/m/y  h:i A',strtotime($data->next_time))}}</td>
                                        <td>
                                            @if($data->status == 0)
                                                <span class="badge bg-primary">{{__('Continue')}}</span>
                                            @else
                                                <span class="badge bg-success">{{__('Complete')}}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty 
                                        <tr>
                                            <td colspan="12" class="text-center">
                                                <div class="no-data-found">
                                                    <span class="icon"><i class="far fa-folder-open"></i></span>
                                                    <p class="mb-0">{{__('No Data Found')}}</p>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        {{$plans->links()}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
