@extends($theme.'frontend.layouts.master')
@section('title',__('Plan'))
@section('content')

<section class="pricing-section">
    <div class="container">
        <ul class="nav nav-pills" id="pills-tab1" role="tablist">
            @if(count($roi_plans))
            <li class="nav-item" role="presentation">
              <button class="active" id="pills-home-tab1" data-bs-toggle="pill" data-bs-target="#nav-roi" type="button">{{__('ROI Investment')}}</button>
            </li>
            @endif
            @if(count($fixed_plans))
            <li class="nav-item" role="presentation">
              <button class=" " id="pills-profile-tab2" data-bs-toggle="pill" data-bs-target="#nav-fixed" type="button">{{__('Fixed Investment')}}</button>
            </li>
            @endif
        </ul>
          <div class="tab-content" id="pills-tabContent1">
            <div class="tab-pane fade show active" id="nav-roi" style="overflow: visible;">
                <div class="row">
                    @foreach($roi_plans as $data)
                    <div class="col-lg-4">
                        <div class="pracing-item ">
                            <div class="top-left">
                                <p>{{__($data->percent)}}%</p>
                            </div>
                            <div class="top-area">
                                <img src="{{url('/')}}/assets/frontend/violet/img/pricing/01.png" alt="img">
                                <p>{{__($data->name)}}</p>
                            </div>
                            <ul>
                                <li><span><i class="fal fa-check"></i></span>{{__('Minimum Deposit')}} {{$data->min_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Maximum Deposit')}} {{$data->max_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Capital Return')}} @if($data->capital_back_status == 1) 
                                    <span class="badge bg-pill bg-danger">@lang('Off')</span> @else <span class="badge bg-pill bg-success">@lang('On')</span> @endif
                                </li>
                                <li><span><i class="fal fa-check"></i></span>{{$data->percent}}% {{__('Payback')}}
                                    @switch($data->period)
                                        @case(1)
                                        {{__('Hourly')}} @break
                                        @case(24)
                                        {{__('Daily')}} @break
                                        @case(168)
                                        {{__('Weekly')}} @break
                                        @case(720)
                                        {{__('Monthly')}} @break
                                        @case(2880)
                                        {{__('Quarterly')}} @break
                                        @case(8640)
                                        {{__('Yearly')}} @break
                                    @endswitch
                                </li>
                            </ul>
                            <a class="buy-now investRoi" data-all="{{$data}}" data-route="{{route('purchase.plan',$data->id)}}"  href="#addModal" data-bs-toggle="modal">{{__('Buy Now')}}</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="tab-pane fade" id="nav-fixed" style="overflow: visible;">
                <div class="row">
                    @foreach($fixed_plans as $data)
                    <div class="col-lg-4">
                        <div class="pracing-item ">
                            <div class="top-left">
                                <p>{{__($data->percent)}}%</p>
                            </div>
                            <div class="top-area">
                                <img src="{{url('/')}}/assets/user/img/pricing/01.png" alt="img">
                                <p>{{__($data->name)}}</p>
                            </div>
                            <ul>
                                <li><span><i class="fal fa-check"></i></span>{{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('ROI Action Lifetime TIMES')}}</li>
                                <li><span><i class="fal fa-check"></i></span>{{__('Capital Return')}} @if($data->capital_back_status == 1) 
                                    <span class="badge bg-pill bg-danger">@lang('Off')</span> @else <span class="badge bg-pill bg-success">@lang('On')</span> @endif
                                </li>
                                <li><span><i class="fal fa-check"></i></span>{{$data->percent}}% {{__('Payback')}}
                                    @switch($data->period)
                                        @case(1)
                                        {{__('Hourly')}} @break
                                        @case(24)
                                        {{__('Daily')}} @break
                                        @case(168)
                                        {{__('Weekly')}} @break
                                        @case(720)
                                        {{__('Monthly')}} @break
                                        @case(2880)
                                        {{__('Quarterly')}} @break
                                        @case(8640)
                                        {{__('Yearly')}} @break
                                    @endswitch
                                </li>
                            </ul>
                            <a class="buy-now investFixed" href="#addModalTwo" data-bs-toggle="modal" data-all="{{$data}}"  data-route="{{route('purchase.plan',$data->id)}}">{{__('Buy Now')}}</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
          </div>
    </div>
</section>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title roiTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="purPlan" action="" method="POST">
                    @csrf
                    <div class="modal-body">
                        <h6 class="text-success text-center totalGetAmount"></h6>
                        <p class="text-primary text-center roiMsg"></p>
                        <div class="form-row">
                            <div class="input-group col-md-12">
                                <input type="text" class="form-control" id="investAmount" name="invest_amount" placeholder="{{__('Put Amount for invest')}}" autocomplete="off">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                </div>
                            </div>
                        </div>
                        <p class="text-danger text-center roiMinMax"></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                        <button type="submit" class="btn btn-success submitBtn">{{__('Submit')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="addModalTwo" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fixTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="purPlanTwo" action="" method="POST">
                    @csrf
                    <div class="modal-body">
                        <h6 class="text-danger text-center tAmountFix"></h6>
                        <h5 class="text-success text-center totalGetAmountFix"></h5>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                        <button type="submit" class="btn btn-success">{{__('Submit')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <input type="hidden" value="{{$general->currency}}" id="currency">

@endsection
