@extends($theme.'frontend.layouts.master')
@section('title',__('Support'))
@section('content')
<div class="transction-section-new">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 mb-3">
                <div class="card walet-address-wrap">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-12 text-end">
                            <a href="{{route('customer.new.ticket')}}" class="btn s7__btn-primary s7__bg-base">
                            <span class="btn-inner--icon"><i class="fa fa-plus"></i></span>
                            <span class="btn-inner--text">{{__('My Tickets')}}</span>
                            </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th>{{__('Sl')}}</th>
                                        <th>{{__('Ticket Id')}}</th>
                                        <th>{{__('Subject')}}</th>
                                        <th>{{__('Raised Time')}}</th>
                                        <th>{{__('Status')}}</th>
                                        <th>{{__('Action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($all_support as $key=>$data)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$data->ticket}}</td>
                                        <td>{{$data->subject}}</td>
                                        <td>{{$data->created_at->format('F dS, Y')}}</td>
                                        <td>
                                        @if($data->status == 1)
                                            <button class="btn btn-warning btn-sm"> {{__('Opened')}}</button>
                                        @elseif($data->status == 2)
                                            <button type="button" class="btn btn-success btn-sm">  {{__('Answered')}} </button>
                                        @elseif($data->status == 3)
                                            <button type="button" class="btn btn-info btn-sm"> {{__('User Reply')}} </button>
                                        @elseif($data->status == 9)
                                            <button type="button" class="btn btn-danger btn-sm">  {{__('Closed')}} </button>
                                        @endif
                                    </td>
                                        <td>
                                        <a class="btn s7__btn-primary s7__bg-base" href="{{route('ticket.customer.reply', $data->ticket )}}"><b>{{__('View')}}</b></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop