@extends($theme.'frontend.layouts.master')
@section('title',__('Support Reply'))
@section('content')

<div class="transction-section-new">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 mb-3">
                <div class="card widget-calendar">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h5 class="h3 mb-0">#{{$ticket_object->ticket}} - {{$ticket_object->subject}}</h5>
                            </div>
                            <div class="col-4 text-end">
                                @if($ticket_object->status == 1)
                                <button class="btn btn-warning btn-sm pull-end"> {{__('Opened')}}</button>
                                @elseif($ticket_object->status == 2)
                                <button type="button" class="btn btn-success btn-sm pull-end">  {{__('Answered')}} </button>
                                @elseif($ticket_object->status == 3)
                                <button type="button" class="btn btn-info btn-sm pull-end"> {{__('Customer Reply')}} </button>
                                @elseif($ticket_object->status == 9)
                                <button type="button" class="btn btn-danger btn-sm pull-end">  {{__('Closed')}} </button>
                                @endif
                                <a href="{{route('ticket.close', $ticket_object->ticket)}}" class="btn btn-danger btn-sm pull-end make-close-support">{{__('Make to Close')}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{route('store.customer.reply', $ticket_object->ticket)}}" accept-charset="UTF-8" class="form-horizontal form-bordered">
                        @csrf
                            <div class="mb-3">
                                <div class="col-md-12">
                                    @foreach($ticket_data as $data)
                                    <div class="card mb-4 @if($data->type == 1) aquamarine @else support_color @endif">
                                        <div class="card-body">
                                            <div class="row align-items-center">
                                                <div class="col ml--2">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h4 class="support_text">
                                                                @if($data->type == 1)
                                                                {{$ticket_object->user_member->name}}
                                                                @else
                                                                {{$ticket_object->admin->name}}
                                                                @endif 
                                                            </h4>
                                                        </div>
                                                        <div class="col-md-6 text-end">
                                                            <small>{{$data->updated_at->format('d M, Y - h:i A') }}</small>
                                                        </div>
                                                    </div>
                                                    <p class="text-sm mb-0 suprt_fnt_clr">{!! $data->comment !!}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="col-md-12 bold">{{__('Reply')}}: </label>
                                <div class="col-md-12 border">
                                    <textarea class="form-control" name="comment" rows="10"></textarea>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary col-md-12"><i class="fa fa-check"></i> {{__('Post')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection