<?php

use App\Http\Controllers\Admin\AddonController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminLoginController;
use App\Http\Controllers\Admin\GeneralController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\DepositController;
use App\Http\Controllers\Admin\EmailTemplateController;
use App\Http\Controllers\Admin\FaqsController;
use App\Http\Controllers\Admin\GatewayController;
use App\Http\Controllers\Admin\IdentyVerifyFromController;
use App\Http\Controllers\Admin\InvestorController;
use App\Http\Controllers\Admin\ManageUserController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\RankingController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\SocialController;
use App\Http\Controllers\Admin\SupportController;
use App\Http\Controllers\Admin\WithDrawMethodController;
use App\Http\Controllers\Admin\WorkAreaController;
use App\Http\Controllers\WalletController;

Route::get('/admin', function(){
    return redirect()->route('admin.login');
});

Route::group(['prefix' => 'admin'], function () {
    Route::controller(AdminLoginController::class)
        ->middleware(['guest:admin'])
        ->group(function () {
            Route::get('login', 'showAdminLoginForm')->name('admin.login');
            Route::post('login', 'adminLogin')->name('admin.login');
        });

    Route::group(['middleware' => ['auth:admin']], function () {
        Route::controller(AdminController::class)->group(function () {
            Route::get('dashboard', 'adminIndex')->name('admin.home');
            Route::get('settings', 'gnlSetting')->name('admin.gnl.set');
            Route::get('select/template', 'selTemplate')->name('admin.gnl.template');
            Route::get('logout', 'adminLogout')->name('admin.logout');

            Route::group(['middleware' => 'permission:pending_kyc'], function () {
                Route::get('users/kyc/pending', 'kycPendingList')->name('kyc.users.pending');
                Route::put('users/kycAction/{id}', 'kycAction')->name('users.Kyc.action');
                Route::get('user/{user}/kyc', 'userKycHistory')->name('user.userKycHistory');
            });

            Route::group(['middleware' => 'permission:log_kyc'], function () {
                Route::get('users/kyc', 'kycList')->name('kyc.users');
            });

            Route::group(['middleware' => 'permission:user_management'], function () {
                Route::get('users', 'usersIndex')->name('user.manage');
                Route::get('users/detail/{id}', 'indexUserDetail')->name('user.view');
                Route::GET('user/search', 'userSearch')->name('username.search');
                Route::GET('user/search/email', 'userSearchEmail')->name('email.search');
                Route::post('users/amount/{id}', 'indexBalanceUpdate')->name('user.balance.update');
                Route::get('users/send/mail/{id}', 'userSendMail')->name('user.mail.send');
                Route::post('send/mail/{id}', 'userSendMailUser')->name('send.mail.user');
                Route::get('users/balance/{id}', 'indexUserBalance')->name('add.subs.index');
                Route::put('users/update/{id}', 'userUpdate')->name('user.detail.update');
                Route::post('user/rank/{id}', 'userRankUpdate')->name('user.rank.update');

                Route::post('active/wallet/users/update/{id}', 'activeUserUpdate')->name('adm-active-wallet.update');
                Route::post('reject/wallet/users/update/{id}', 'rejectUserUpdate')->name('adm-reject-wallet.update');
            });

            Route::group(['middleware' => 'permission:active_user'], function () {
                Route::get('active-user', 'usersActiveIndex')->name('active.user.manage');
            });

            Route::group(['middleware' => 'permission:ban_user'], function () {
                Route::get('ban-user', 'usersBanndedIndex')->name('ban.user.manage');
            });

            Route::group(['middleware' => 'permission:transaction'], function () {
                Route::get('transactions', 'transactionIndex')->name('transaction.log.admin');
                Route::get('search-transaction/', 'searchResult')->name('search.trans.admin');
            });

            Route::group(['middleware' => 'permission:referral'], function () {
                Route::get('referral', 'referralIndex')->name('admin.referral');
                Route::post('referral', 'referralStore')->name('admin.referral.update');
            });

            Route::get('profile', 'changePass')->name('admin.changePass');
            Route::post('profile/updatePassword', 'updatePassword')->name('admin.updatePassword');
        });

        Route::controller(GeneralController::class)
            ->middleware(['middleware' => 'permission:settings'])
            ->group(function () {
                Route::post('general', 'generalStore')->name('general.store');
                Route::get('seo/manager', 'seoManager')->name('admin.seo');
                Route::post('seo/manager', 'seoStore');

                
                Route::get('/manage/theme', 'manageTheme')->name('manage.theme');
                Route::put('/activate/theme/{name}', 'activateTheme')->name('activate.themeUpdate');
                

                Route::group(['middleware' => 'permission:banner'], function () {
                    Route::get('banner', 'bannerIndex')->name('banner.index');
                });

                Route::group(['middleware' => 'permission:logo'], function () {
                    Route::get('logo-icon', 'logoIcon')->name('logo-icon.index');
                });

                Route::group(['middleware' => 'permission:ico'], function () {
                    Route::get('ico', 'icoIndex')->name('ico_settings.index');
                });
                Route::group(['middleware' => 'permission:web_interface'], function () {
                    Route::get('about', 'aboutIndex')->name('about-area.index');
                });

                Route::group(['middleware' => 'permission:google_tools'], function () {
                    Route::get('google-tools', 'googleToolsIndex')->name('google_tools.index');
                });
            });

        Route::group(['middleware' => 'permission:ranking'], function () {
            Route::resource('ranking', RankingController::class);
        });

        Route::controller(LanguageController::class)
            ->middleware(['middleware' => 'permission:language'])
            ->group(function () {
                Route::get('/language/manager', 'langManage')->name('language-manage');
                Route::post('/language/manager', 'langStore')->name('language-manage-store');
                Route::delete('language-manage/{id}', 'langDel')->name('language-manage-del');
                Route::get('language-key/{id}', 'langEdit')->name('language-key');
                Route::put('key-update/{id}', 'langUpdate')->name('key-update');
                Route::post('language-manage-update/{id}', 'langUpdatepp')->name('language-manage-update');
                Route::post('language-import', 'langImport')->name('import_lang');
            });

        Route::resource('faq', FaqsController::class);

        Route::controller(WalletController::class)->group(function () {
            Route::get('credit-card-request', 'request')->name('credit-card-request');
            Route::post('credit-card-request/{id}', 'changeStatus')->name('credit-card-accept');
        });

        Route::controller(AddonController::class)->group(function () {
            Route::get('addon', 'index')->name('addon');
            Route::post('addon', 'installUpdate');
            Route::post('addon/changeStatus/{id}', 'addonStatus')->name('addon.status');
            Route::post('addon/delete/{id}', 'delete')->name('addon.delete');
        });

        Route::controller(IdentyVerifyFromController::class)
            ->middleware(['middleware' => 'permission:identity_form'])
            ->group(function () {
                Route::get('/identity-form', 'index')->name('identify-form.index');
                Route::get('identity-form/edit/{id}', 'edit')->name('identify-form.edit');
                Route::put('identity-form/edit/{id}', 'update');
                Route::post('/identity-form', 'store')->name('identify-form.store');
            });

        Route::controller(NotificationController::class)->group(function () {
            Route::get('notifications', 'notifications')->name('admin.notifications');
            Route::get('notification/read/{id}', 'notificationRead')->name('admin.notification.read');
            Route::get('notifications/read-all', 'readAll')->name('admin.notifications.readAll');
        });

        Route::controller(EmailTemplateController::class)
            ->middleware(['middleware' => 'permission:email_settings'])
            ->group(function () {
                Route::resource('email-template', EmailTemplateController::class);
                Route::get('email-controls', 'emailControl')->name('admin.email-controls');
                Route::post('email-controls', 'emailConfigure')->name('admin.email-controls.update');
                Route::get('global-template', 'globalControl')->name('admin.global-template');
                Route::post('global-template', 'globalConfigure')->name('admin.global-template.update');
                Route::post('email-template/{id}/update', 'update')->name('email-template.update');
            });

            Route::group(['middleware' => 'permission:web_interface'], function () {
                Route::controller(WorkAreaController::class)->group(function () {
                    Route::get('work-area', 'workIndex')->name('work-area.index');
                    Route::get('work-area/create', 'workCreate')->name('work-area.create');
                    Route::post('work-area', 'workStore')->name('work-area.store');
                    Route::get('work-area/{workArea}', 'workEdit')->name('work-area.edit');
                    Route::put('work-area/{workArea}', 'workUpdate')->name('work-area.update');
                    Route::delete('work-area/{workArea}', 'workDelete')->name('work-area.delete');
                });
            
                Route::controller(ServiceController::class)->group(function () {
                    Route::get('service-area', 'workIndex')->name('service-area.index');
                    Route::get('service-area/create', 'workCreate')->name('service-area.create');
                    Route::post('service-area', 'workStore')->name('service-area.store');
                    Route::get('service-area/{workArea}', 'workEdit')->name('service-area.edit');
                    Route::put('service-area/{workArea}', 'workUpdate')->name('service-area.update');
                    Route::delete('service-area/{workArea}', 'workDelete')->name('service-area.delete');
                });
            
                Route::controller(InvestorController::class)->group(function () {
                    Route::get('investor-area', 'workIndex')->name('investor-area.index');
                    Route::get('investor-area/create', 'workCreate')->name('investor-area.create');
                    Route::post('investor-area', 'workStore')->name('investor-area.store');
                    Route::get('investor-area/{workArea}', 'workEdit')->name('investor-area.edit');
                    Route::put('investor-area/{workArea}', 'workUpdate')->name('investor-area.update');
                    Route::delete('investor-area/{workArea}', 'workDelete')->name('investor-area.delete');
                });
            
                Route::controller(PartnerController::class)->group(function () {
                    Route::get('partner-area', 'workIndex')->name('partner-area.index');
                    Route::post('partner-area', 'workStore')->name('partner-area.store');
                    Route::put('partner-area/{workArea}', 'workUpdate')->name('partner-area.update');
                    Route::delete('partner-area/{workArea}', 'workDelete')->name('partner-area.delete');
                });
            
                Route::controller(SocialController::class)->group(function () {
                    Route::get('social-area', 'workIndex')->name('social-area.index');
                    Route::post('social-area', 'workStore')->name('social-area.store');
                    Route::put('social-area/{workArea}', 'workUpdate')->name('social-area.update');
                    Route::delete('social-area/{workArea}', 'workDelete')->name('social-area.delete');
                });
            
                Route::controller(SliderController::class)->group(function () {
                    Route::get('slider-area', 'sliderIndex')->name('slider-area.index');
                    Route::post('slider-area', 'sliderStore')->name('slider-area.store');
                    Route::put('slider-area/{sliderArea}', 'sliderUpdate')->name('slider-area.update');
                    Route::delete('slider-area/{sliderArea}', 'sliderDelete')->name('slider-area.delete');
                });
            });
            
            Route::group(['middleware' => 'permission:news'], function () {
                Route::controller(NewsController::class)->group(function () {
                    Route::get('news-area', 'workIndex')->name('news-area.index');
                    Route::get('news-area/create', 'workCreate')->name('news-area.create');
                    Route::post('news-area', 'workStore')->name('news-area.store');
                    Route::get('news-area/{workArea}', 'workEdit')->name('news-area.edit');
                    Route::put('news-area/{workArea}', 'workUpdate')->name('news-area.update');
                    Route::delete('news-area/{workArea}', 'workDelete')->name('news-area.delete');
                });
            });
            
            Route::group(['middleware' => 'permission:menu'], function () {
                Route::controller(MenuController::class)->group(function () {
                    Route::get('menu-area', 'workIndex')->name('menu-area.index');
                    Route::get('menu-area/create', 'workCreate')->name('menu-area.create');
                    Route::post('menu-area', 'workStore')->name('menu-area.store');
                    Route::get('menu-area/{workArea}', 'workEdit')->name('menu-area.edit');
                    Route::put('menu-area/{workArea}', 'workUpdate')->name('menu-area.update');
                    Route::delete('menu-area/{workArea}', 'workDelete')->name('menu-area.delete');
                });
            });
            
            Route::group(['middleware' => 'permission:plan'], function () {
                Route::controller(PlanController::class)->group(function () {
                    Route::get('plan-area', 'workIndex')->name('plan-area.index');
                    Route::get('plan-area/create', 'workCreate')->name('plan-area.create');
                    Route::post('plan-area', 'workStore')->name('plan-area.store');
                    Route::get('plan-area/{workArea}', 'workEdit')->name('plan-area.edit');
                    Route::put('plan-area/{workArea}', 'workUpdate')->name('plan-area.update');
                    Route::delete('plan-area/{workArea}', 'workDelete')->name('plan-area.delete');
                });
            });
            
            Route::group(['middleware' => 'permission:schedule'], function () {
                Route::controller(PlanController::class)->group(function () {
                    Route::get('/schedule-manage', 'scheduleIndex')->name('scheduleIndex');
                    Route::post('/schedule-create', 'storeSchedule')->name('store.schedule');
                    Route::put('/schedule-update/{id}', 'updateSchedule')->name('update.schedule');
                });
            });
            
            Route::group(['middleware' => 'permission:gateway_management'], function () {
                Route::controller(GatewayController::class)->group(function () {
                    Route::get('manual/gateway', 'ManualIndex')->name('admin.manual.gateway');
                });
                Route::resource('gateway', GatewayController::class);
            });
            
            Route::group(['middleware' => 'permission:withdraw_method'], function () {
                Route::resource('withdraw-method', WithDrawMethodController::class);
            });
            
            Route::group(['middleware' => 'permission:withdraw_pending'], function () {
                Route::controller(WithDrawMethodController::class)->group(function () {
                    Route::get('withdraw/requests', 'requestWithdraw')->name('withdraw.request.index');
                    Route::get('withdraw/details/{id}', 'detailWithdraw')->name('withdraw.detail.user');
                    Route::get('withdraw/showReceipt/{id}', 'showReceipt')->name('admin.withdraw.showReceipt');
                    Route::post('withdraw/update/{id}', 'repondWithdraw')->name('withdraw.process');
                });
            });
            
            Route::group(['middleware' => 'permission:withdraw_log'], function () {
                Route::controller(WithDrawMethodController::class)->group(function () {
                    Route::get('withdraw/log', 'showWithdrawLog')->name('withdraw.viewlog.admin');
                });
            });
            
            Route::group(['middleware' => 'permission:support'], function () {
                Route::controller(SupportController::class)->group(function () {
                    Route::get('support', 'supportIndex')->name('support.index');
                    Route::get('/support/reply/{support}', 'adminSupport')->name('support.admin.reply');
                    Route::post('/reply/{support}', 'adminReply')->name('store.admin.reply');
                });
            });
            
            Route::group(['middleware' => 'permission:manage_user'], function () {
                Route::controller(ManageUserController::class)->group(function () {
                    Route::get('user-group', 'index')->name('admin.user_group');
                    Route::get('group/create', 'create')->name('admin.group.create');
                    Route::post('group/store', 'store')->name('admin.group.store');
                    Route::get('group/{id}/edit', 'edit')->name('admin.group.edit');
                    Route::post('group/{id}/update', 'update')->name('admin.group.update');
                    Route::get('user', 'getUser')->name('admin.user');
                    Route::post('user/store', 'userStore')->name('admin.user.store');
                    Route::post('user/update/{id}', 'userUpdate')->name('admin.user.update');
                });
            });
            
            Route::group(['middleware' => 'permission:deposit_pending'], function () {
                Route::controller(DepositController::class)->group(function () {
                    Route::get('deposit/pending', 'pending')->name('admin.deposit.pending');
                    Route::get('deposit/showReceipt/{id}', 'showReceipt')->name('admin.deposit.showReceipt');
                    Route::post('deposit/accept', 'accept')->name('admin.deposit.accept');
                    Route::post('deposit/rejectReq', 'rejectReq')->name('admin.deposit.rejectReq');
                });
            });
            
            Route::group(['middleware' => 'permission:deposit_accept'], function () {
                Route::controller(DepositController::class)->group(function () {
                    Route::get('deposit/acceptedRequests', 'acceptedRequests')->name('admin.deposit.acceptedRequests');
                });
            });
            
            Route::group(['middleware' => 'permission:deposit_log'], function () {
                Route::controller(DepositController::class)->group(function () {
                    Route::get('deposit/depositLog', 'depositLog')->name('admin.deposit.depositLog');
                });
            });
            
            Route::group(['middleware' => 'permission:deposit_reject'], function () {
                Route::controller(DepositController::class)->group(function () {
                    Route::get('deposit/rejectedRequests', 'rejectedRequests')->name('admin.deposit.rejectedRequests');
                });
            });
            
    });
});
