<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PayPalController;
use App\Http\Controllers\CoinpaymentController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\PayFastController;
use App\Http\Controllers\PayStackController;
use App\Http\Controllers\FlutterwaveController;
use App\Http\Controllers\PaytmController;
use App\Http\Controllers\SkrillPaymentController;
use App\Http\Controllers\AuthorizeNetController;
use App\Http\Controllers\MollieController;
use App\Http\Controllers\InstamojoController;
use App\Http\Controllers\SecurionPayController;
use App\Http\Controllers\CoingateController;
use App\Http\Controllers\CoinbasecommerceController;
use App\Http\Controllers\TwocheckoutController;
use App\Http\Controllers\RazorpayController;

Route::controller(PayPalController::class)->group(function () {
    Route::get('payment', 'payment');
    Route::get('cancel', 'cancel')->name('paypal.payment.cancel');
    Route::get('payment/success', 'success')->name('paypal.payment.success');
});

Route::controller(CoinpaymentController::class)->group(function () {
    Route::post('/ipncoin', 'ipnCoin')->name('ipn.coinpayemnt');
});

Route::controller(StripeController::class)->group(function () {
    Route::post('/ipnstripe', 'ipnstripe')->name('ipn.stripe');
});

Route::controller(PayFastController::class)->group(function () {
    Route::any('/payfast-success', 'success')->name('payfast.payment.success');
    Route::any('/payfast-cancel', 'cancel')->name('payfast.payment.cancel');
    Route::any('/payfast-notify', 'notify')->name('payfast.payment.notify');
});

Route::controller(PayStackController::class)->group(function () {
    Route::post('/paystack-pay', 'redirectToGateway')->name('paystack.pay');
    Route::get('/paystack-payment/callback', 'handleGatewayCallback');
});

Route::controller(FlutterwaveController::class)->group(function () {
    Route::post('/rave-pay', 'initialize')->name('rave.pay');
    Route::get('/rave/callback', 'callback')->name('rave.callback');
});

Route::controller(PaytmController::class)->group(function () {
    Route::post('paytm-payment', 'order')->name('paytm.payment');
    Route::post('paytm/callback', 'paymentCallback')->name('paytm.callback');
});

Route::controller(SkrillPaymentController::class)->group(function () {
    Route::post('skrill-ipn', 'ipn')->name('skrill.ipn');
    Route::get('skrill-complete', 'complete')->name('skrill.payment.complete');
    Route::get('skrill-cancelled', 'cancelled')->name('skrill.payment.cancelled');
});

Route::controller(AuthorizeNetController::class)->group(function () {
    Route::get('/authorize-pay', 'pay')->name('authorize.pay');
    Route::any('/dopay/online', 'handleonlinepay')->name('authorize.dopay.online');
});

Route::controller(MollieController::class)->group(function () {
    Route::get('mollie-payment', 'preparePayment')->name('mollie.payment');
    Route::get('mollie-payment-success', 'paymentSuccess')->name('mollie.payment.success');
});

Route::controller(InstamojoController::class)->group(function () {
    Route::get('instamojo-event', 'instamojoIndex');
    Route::post('instamojo-pay', 'instamojoPay')->name('instamojo.pay');
    Route::get('instamojo-pay-success', 'instamojoSuccess')->name('instamojo.payment.success');
});

Route::controller(SecurionPayController::class)->group(function () {
    Route::post('sceurionpay-ipn', 'ipn')->name('sceurionpay.ipn');
});

Route::controller(CoingateController::class)->group(function () {
    Route::post('coingate-ipn', 'ipn')->name('coingate.ipn');
    Route::get('coingate-failed', 'failed')->name('coingate.failed');
    Route::get('coingate-success', 'success')->name('coingate.success');
});

Route::controller(CoinbasecommerceController::class)->group(function () {
    Route::post('coinbasecommerce-ipn', 'ipn')->name('coinbasecommerce.ipn');
    Route::get('coinbasecommerce-failed', 'failed')->name('coinbasecommerce.failed');
});

Route::controller(TwocheckoutController::class)->group(function () {
    Route::post('twocheckout', 'prepareData')->name('twocheckout.prepareData');
    Route::post('twocheckout-ipn', 'ipn')->name('twocheckout.ipn');
    Route::get('twocheckout-success', 'success')->name('twocheckout.success');
    Route::get('twocheckout-failed', 'failed')->name('twocheckout.failed');
});

Route::controller(RazorpayController::class)->group(function () {
    Route::any('razorpay-payment', 'store')->name('razorpay.payment.store');
});

