<?php

use App\Http\Controllers\Admin\SupportController;
use App\Http\Controllers\Auth\ConfirmPasswordController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentGatwayController;
use App\Http\Controllers\UiController;
use App\Http\Controllers\WalletController;
use Illuminate\Support\Facades\Route;

Route::get('/cron', [UiController::class, 'cronAction']);


Route::middleware('web','guest')->group(function () {
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login']);

    // Registration Routes
    Route::get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('register', [RegisterController::class, 'register']);

    // Password Reset Routes
    Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
    Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
    Route::post('password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');

    // Email Verification Routes
    Route::get('email/verify', [VerificationController::class, 'show'])->name('verification.notice');
    Route::get('email/verify/{id}/{hash}', [VerificationController::class, 'verify'])->name('verification.verify');
    Route::post('email/resend', [VerificationController::class, 'resend'])->name('verification.resend');

    // Password Confirmation
    Route::get('password/confirm', [ConfirmPasswordController::class, 'showConfirmForm'])->name('password.confirm');
    Route::post('password/confirm', [ConfirmPasswordController::class, 'confirm']);
});

Route::controller(RegisterController::class)
    ->group(function () {
        Route::get('register/{referral_token}', 'showRegistrationForm');
    })
    ->middleware('guest');

Route::controller(LoginController::class)
    ->group(function () {
        Route::get('/login/google', 'redirectToGoogle')->name('login.google');
        Route::get('/login/google/callback', 'handleGoogleCallback');
        Route::get('/login/facebook', 'redirectToFacebook')->name('login.facebook');
        Route::get('/login/facebook/callback', 'handleFacebookCallback');
    })
    ->middleware('guest');

Route::get('/', [UiController::class, 'index'])->name('website.home');

Route::get('/change-lang/{lang}', [UiController::class, 'changeLang'])->name('lang');

Route::get('single/{class?}/{id?}', [UiController::class, 'singlePage'])->name('single.page');

Route::get('news', [UiController::class, 'newsIndex'])->name('news.index');

Route::get('contact', [UiController::class, 'contactsIndex'])->name('contacts.index');

// Forgot Password Routes
Route::controller(ForgotPasswordController::class)->group(function () {
    Route::get('/showEmailForm', 'showEmailForm')->name('user.showEmailForm');
    Route::post('/sendResetPassMail', 'sendResetPassMail')->name('user.sendResetPassMail');
    Route::get('/reset/{code}', 'resetPasswordForm')->name('user.resetPasswordForm');
    Route::post('/resetPassword', 'resetPassword')->name('user.resetPassword');
});

// Authorization and Verification Routes
Route::controller(HomeController::class)
    ->group(function () {
        Route::get('/authorization', 'authorization')->name('authorization');
        Route::post('/sendemailver', 'sendemailver')->name('sendemailver');
        Route::post('/emailverify', 'emailverify')->name('emailverify');
        Route::post('/g2fa-verify', 'verify2fa')->name('go2fa.verify');
    })
    ->middleware('auth');

Route::middleware('auth', 'ckstatus', 'kyc')->group(function () {

    Route::post('logout', [LoginController::class, 'logout'])->name('logout');

    Route::controller(HomeController::class)->group(function () {
        Route::get('home', 'index')->name('home');
        Route::get('invest', 'investIndex')->name('invest.index');
        Route::get('wallet', 'walletIndex')->name('wallet.index');
        Route::get('my-wallet-transaction', 'myWalletTransactionIndex')->name('my.wallet.transaction.log');
        Route::get('other-wallet-transaction', 'otherWalletTransactionIndex')->name('other.wallet.transaction.log');
        Route::post('confirm-coin-wallet/{id}', 'confirmWallet')->name('confirm-coin-wallet.store');
        Route::post('reject-coin-wallet/{id}', 'rejectWallet')->name('reject-coin-wallet.store');
    });

    Route::get('credit-card', [WalletController::class, 'index'])->name('credit-card');
    Route::post('credit-card', [WalletController::class, 'store']);

    // HomeController Routes
    Route::controller(HomeController::class)->group(function () {
        Route::get('invest-log', 'investLog')->name('invest.log');
        Route::get('transaction-log', 'transactionLog')->name('transaction.log');
        Route::get('min-crypto', 'purchaseCoin')->name('purchase.coin');
        Route::post('min-crypto', 'purchaseCoinStore')->name('purchase-coin.store');
        Route::post('min-crypto-send', 'purchaseCoinSendStore')->name('purchase-coin-send.store');
        Route::post('min-crypto-receive', 'purchaseCoinReceiveStore')->name('purchase-coin-receive.store');
        Route::get('fund-transfer', 'fundTransIndex')->name('fund.transfer');
        Route::post('fund-transfer', 'fundTransStore')->name('transfer.store');
        Route::post('purchase/{plan}', 'purPlan')->name('purchase.plan');
        Route::get('withdraw', 'withdrawIndex')->name('user.withdraw.method');
        Route::post('withdraw/preview', 'withdrawPreview')->name('withdraw.preview.user');
        Route::post('confirm/withdraw', 'storeWithdraw')->name('confirm.withdraw.store');
        Route::get('withdraw-log', 'withdrawLog')->name('user.withdraw.log');
        Route::get('withdraw/{code}', 'WithdrawGateway')->name('user.withdraw.gateway');
        Route::post('new-wallet', 'newWalletStore')->name('new-wallet.store');
        Route::get('deposit-log', 'depositLog')->name('user.deposit.log');
        Route::get('referral/{level?}', 'myRef')->name('user.ref.index');
        Route::get('search-transaction/', 'searchTrans')->name('search.trans.user');
    });

    // PaymentGatewayController Routes
    Route::controller(PaymentGatwayController::class)->group(function () {
        Route::match(['get', 'post'], 'deposit', 'addDeposit')->name('users.showDepositMethods');
        Route::post('deposit-amount-insert', 'depositAmountInsert')->name('submit.amount.deposit');
        Route::get('deposit/{code}', 'gateway')->name('user.deposit.gateway');
        Route::get('deposit-preview', 'depositPreview')->name('user.deposit.preview');
        Route::post('deposit-confirm', 'depositPayNow')->name('deposit.confirm');
    });

    // HomeController Routes
    Route::controller(HomeController::class)->group(function () {
        Route::get('profile', 'profileIndex')->name('profile.index');
        Route::post('profile', 'profileUpdate')->name('profile.update');
        Route::post('password', 'passwordUpdate')->name('password.update');

        Route::get('/security/two/step', 'twoFactorIndex')->name('two.factor.index');
        Route::post('/g2fa-create', 'create2fa')->name('go2fa.create');
        Route::post('/g2fa-disable', 'disable2fa')->name('disable.2fa');

        Route::post('bvn', 'kycUpdate')->name('kyc.update');
        Route::get('kyc', 'kycIndex')->name('user.kyc.index');
        Route::post('/verificationSubmit', 'verificationSubmit')->name('user.verificationSubmit');
    });

    Route::controller(SupportController::class)->group(function () {
        Route::get('support/ticket', 'customerSupportIndex')->name('customer.support.index');
        Route::get('support/new', 'ticketCreate')->name('customer.new.ticket');
        Route::post('store/ticket', 'ticketStore')->name('ticket.store');
        Route::get('comment/close/{support}', 'ticketClose')->name('ticket.close');
        Route::get('support/reply/{support}', 'ticketReply')->name('ticket.customer.reply');
        Route::post('support/store/{support}', 'ticketReplyStore')->name('store.customer.reply');
    });
});
