<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(__($general->web_name)); ?> | <?php echo $__env->yieldContent(__('title')); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>" sizes="16x16">
    <?php if(request()->routeIs('single.page')): ?>
        <meta name="description" content="<?php echo e($menu->seo_details ?? $general->seo_details); ?>">
        <meta name="title" content="<?php echo e($menu->seo_title ?? $general->seo_title); ?>">
    <?php else: ?>
        <meta name="description" content="<?php echo e($general->seo_details); ?>">
        <meta name="title" content="<?php echo e($general->seo_title); ?>">
    <?php endif; ?>
    <?php echo $__env->make($theme . 'frontend.layouts.partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body>
    
    <div class="back-to-top">
        <i class="las la-arrow-up"></i>
    </div>

    <div class="preloader-holder">
        <div class="preloader">
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        </div>
    </div>

    <?php echo $__env->make($theme . 'frontend.layouts.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make($theme . 'frontend.layouts.slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make($theme . 'frontend.layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make($theme . 'frontend.layouts.partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('script'); ?>

    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                (function($) {
                    "use strict";
                    toastr.warning('<?php echo e($error); ?>')
                })
                (jQuery);
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php if(Session::has('message')): ?>
        <script>
            (function($) {
                "use strict";
                toastr.success('<?php echo e(Session::get('message')); ?>');
            })(jQuery);
        </script>
    <?php endif; ?>
    <?php if(session()->has('success')): ?>
        <script>
            (function($) {
                "use strict";
                toastr.success('<?php echo e(session()->get('success')); ?>')
            })(jQuery);
        </script>
    <?php endif; ?>
    <?php if(session()->has('alert')): ?>
        <script>
            (function($) {
                "use strict";
                toastr.error('<?php echo e(session()->get('alert')); ?>')
            })(jQuery);
        </script>
    <?php endif; ?>

</body>
</html><?php /**PATH /home/mrsen07/invesproupdate.wowtheme7.com/scripts/resources/views/theme/mediumpurple/frontend/layouts/master.blade.php ENDPATH**/ ?>