<?php $__env->startSection('title', __('Ranking')); ?>
<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Ranking List'); ?> <button class="btn btn-success btn-sm float-end" data-bs-toggle="modal"
                    data-bs-target="#addRanking"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New Ranking'); ?></a> </h4>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Name'); ?></th>
                        <th><?php echo app('translator')->get('Minimum Deposit'); ?></th>
                        <th><?php echo app('translator')->get('Minimum Invest'); ?></th>
                        <th><?php echo app('translator')->get('Minimum Referral'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__empty_1 = true; $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ranking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <img width="50" src="<?php echo e(asset('assets/images/ranking/' . $ranking->image)); ?>">
                                <?php echo e($ranking->title); ?>

                            </td>
                            <td>
                                <?php echo e($ranking->minimum_deposit); ?>

                            </td>
                            <td>
                                <?php echo e($ranking->minimum_invest); ?>

                            </td>
                            <td>
                                <?php echo e($ranking->minimum_referral); ?>

                            </td>
                            <td>
                                <?php if($ranking->status): ?>
                                    <span class="s7__badge s7__badge-primary"><?php echo e(__('Active')); ?></span>
                                <?php else: ?>
                                    <span class="s7__badge s7__badge-primary"><?php echo e(__('Deactive')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm edit" data-bs-toggle="modal"
                                    data-bs-target="#editModal" data-href="<?php echo e(route('ranking.update', $ranking->id)); ?>"
                                    data-ranking="<?php echo e($ranking); ?>"><?php echo e(__('Edit')); ?></button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr class="text-center" colspan="100%">
                            <td><?php echo e(__('No Data Found')); ?></td>
                        </tr>
                    <?php endif; ?>

                </tbody>
            </table>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addRanking" tabindex="-1" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form action="<?php echo e(route('ranking.store')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            <?php echo e(__('Add Ranking')); ?>

                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Ranking Name')); ?></label>
                                <input type="text" name="title" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Ranking Image')); ?></label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Deposit')); ?></label>
                                <input type="text" name="minimum_deposit" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Invest')); ?></label>
                                <input type="text" name="minimum_invest" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Referral user')); ?></label>
                                <input type="text" name="minimum_referral" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Bonus')); ?></label>
                                <input type="text" name="bonus" class="form-control">
                            </div>


                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Status')); ?></label>
                                <select name="status" id="" class="form-control">
                                    <option value="1"><?php echo e(__('Active')); ?></option>
                                    <option value="0"><?php echo e(__('Deactive')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <?php echo e(__('Close')); ?>

                        </button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form action="" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            <?php echo e(__('Edit Ranking')); ?>

                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Ranking Name')); ?></label>
                                <input type="text" name="title" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Ranking Image')); ?></label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Deposit')); ?></label>
                                <input type="text" name="minimum_deposit" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Invest')); ?></label>
                                <input type="text" name="minimum_invest" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Minimum Referral user')); ?></label>
                                <input type="text" name="minimum_referral" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Bonus')); ?></label>
                                <input type="text" name="bonus" class="form-control">
                            </div>


                            <div class="col-md-6">
                                <label for=""><?php echo e(__('Status')); ?></label>
                                <select name="status" id="" class="form-control">
                                    <option value="1"><?php echo e(__('Active')); ?></option>
                                    <option value="0"><?php echo e(__('Deactive')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <?php echo e(__('Close')); ?>

                        </button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function() {
            $('.edit').on('click', function() {
                let route = $(this).data('href')
                let ranking = $(this).data('ranking')

                let modal = $('#editModal')

                modal.find('form').attr('action', route);

                modal.find('input[name=title]').val(ranking.title)
                modal.find('input[name=minimum_deposit]').val(ranking.minimum_deposit)
                modal.find('input[name=minimum_invest]').val(ranking.minimum_invest)
                modal.find('input[name=minimum_referral]').val(ranking.minimum_referral)
                modal.find('input[name=bonus]').val(ranking.bonus)
                modal.find('select[name=status]').val(ranking.status)

            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/admin/ranking/index.blade.php ENDPATH**/ ?>