
<?php $__env->startSection('title', __('Withdraw Preview')); ?>
<?php $__env->startSection('content'); ?>
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('confirm.withdraw.store')); ?>" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <?php
                            $charge = ((floatval($amount) * floatval($method->chargepc))/100) + floatval($amount) + floatval($method->chargefx);
                        ?>
                        <input type="hidden" name="amount" value="<?php echo e($amount); ?>" >
                        <input type="hidden" name="method_id" value="<?php echo e($method->id); ?>" >
                            <div class="row gy-4 justify-content-center">
                                <div class="col-xl-4 col-md-6">
                                    <div class="thumb mb-4 align-self-center">
                                        <img src="<?php echo e(asset('assets/images/withdraw_methods/'.$method->image)); ?>" alt="icon">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="facility-details">
                                        <ul class="list-group mb-4">
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span><?php echo e(__('Request for Withdraw Amount')); ?>:</span>
                                                <span><strong><?php echo e($amount); ?></strong> <?php echo e($general->currency); ?></span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span><?php echo e(__('Charge')); ?> :</span>
                                                <span class="text-danger"><strong><?php echo e(((floatval($amount) * floatval($method->chargepc))/100)+ floatval($method->chargefx)); ?></strong> <?php echo e($general->currency); ?> | (<?php echo e($method->chargepc); ?> % + <?php echo e($method->chargefx); ?> <?php echo e($general->currency); ?>)</span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span><?php echo e(__('Total Amount Deduct')); ?>:</span>
                                                <span><strong><?php echo e($charge); ?></strong> <?php echo e($general->currency); ?></span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span><?php echo e(__('In')); ?> <?php echo e($method->currency); ?>:</span>
                                                <span><strong><?php echo e(round($amount*$method->rate, 4)); ?></strong> <?php echo e($method->currency); ?></span>
                                            </li>
                                            <li class="list-group-item d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                <span><?php echo e(__('Payment Gateway')); ?>:</span>
                                                <span class="text-primary"><strong><?php echo e($method->name); ?></strong></span>
                                            </li>
                                        </ul>
                                        <div class="row manual-row gy-3">
                                            
                                        </div>
                                    </div>
                                    <div class="col-12 text-center mt-3 mb-3">
                                        <input type="submit" class="btn btn-base border-radius-5 pe-5 ps-5" id="btn-confirm" value="<?php echo e(__('Confirm Withdraw')); ?>">
                                    </div>
                                </div>
                            </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    var globalData;
    $(document).ready(function() {

        "use strict"
        $('.manual-row').empty();
        var code = <?php echo e($method->id); ?>;
        var url = '<?php echo e(route("user.withdraw.gateway",":code")); ?>';
        url = url.replace(':code', code);
        $.get(url, function (data) {
            globalData = data;
            if (data.credentials !== undefined) {
                $('.manual-row').append(data.credentials)

            }

        });

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/theme/mediumpurple/user/withdraw/preview.blade.php ENDPATH**/ ?>