<?php $__env->startSection('title',__('Transfer Your Balance')); ?>
<?php $__env->startSection('content'); ?>
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <form method="POST" action="<?php echo e(route('transfer.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="single-facility card">
                        <div class="card-body">
                            <div class="title text-center">
                                <h3 class="mb-3"><?php echo e(__('Share your Balance with Other User')); ?></h3>
                            </div>
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <p class="text-danger mb-1"> <?php echo e($general->bal_trans_percentage_charge); ?>% <?php echo e(__('Transfer Charge will Applied and transferred Fund will go to Secondary Balance.')); ?></p>
                                    <p class="text-danger"> <?php echo e($general->bal_trans_fixed_charge); ?> <?php echo e($general->currency); ?> <?php echo e(__('fixed transfer Charge will Applied and transferred Fund will go to Secondary Balance.')); ?></p>
                                    <hr>
                                </div>
                            </div>
                            <div class="form-group">
                                <label><?php echo e(__('Receiver Email')); ?> :</label>
                                <input type="email" name="email" class="form-control" placeholder="<?php echo e(__('Email to Transfer')); ?>" required autocomplete="email" autofocus>
                            </div>
                            <div class="form-group">
                                <label><?php echo e(__('Amount')); ?> :</label>
                                <input type="text" name="amount" class="form-control" id="amount" placeholder="<?php echo e(__('AMOUNT YOU WANT TO SHARE')); ?>" autocomplete="off" required>
                                <span class="text-danger wrnMsg"></span>
                            </div>
                        </div>
                        <div class="col-12 text-center mt-3 mb-3">
                            <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5"><?php echo e(__('Transfer Now')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
        $(document).ready(function () {
            let fixedCharge, percentCharge;
            fixedCharge = '<?php echo e($general->bal_trans_fixed_charge); ?>';
            percentCharge = '<?php echo e($general->bal_trans_percentage_charge); ?>';
            $('#amount').on('keyup',function () {
                var amt = this.value;
                if (($.isNumeric(amt)) && (parseFloat(amt) > 0)){
                    var perCharge = (parseFloat(amt)*parseFloat(percentCharge))/100;
                    var totalCharge = perCharge+parseFloat(fixedCharge);
                    var total = parseFloat(amt)+parseFloat(totalCharge);
                    msg('Total '+parseFloat(total)+' <?php echo e($general->currency); ?> wil deduct from your balance.');
                } else {
                    msg('Amount should be numeric & greater than 0');
                }

            });
            function msg(msg) {
                $('.wrnMsg').text(msg);
            }
        });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/theme/mediumpurple/user/fund-trans.blade.php ENDPATH**/ ?>