<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(__('Application Installer')); ?></title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/vendor/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/main.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/toastr.min.css')); ?>">
    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body>
    <?php echo $__env->yieldContent('content'); ?>


    <!-- Jquery js -->
    <script src="<?php echo e(asset('assets/backend/js/vendor/jquery-3.6.0.min.js')); ?>"></script>


    <script src="<?php echo e(asset('assets/backend/js/vendor/toastr.min.js')); ?>"></script>

    <?php if(session()->has('error')): ?>
        <script>
            (function($) {
                "use strict";
                toastr.error('<?php echo e(session()->get('error')); ?>')
            })(jQuery);
        </script>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                (function($) {
                    "use strict";
                    toastr.warning('<?php echo e($error); ?>')
                })
                (jQuery);
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

</body>

</html>
<?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/installer/master.blade.php ENDPATH**/ ?>