
<?php $__env->startSection('title',__($page_title)); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('gateway.update', $gateway->id)); ?>" method="post" enctype="multipart/form-data" class="forms-sample">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <div class="row mb-3">
                <div class="col-md-5">
                    <input class="form-control" value="<?php echo e($gateway->id); ?>" type="hidden" name="id">
                    <div class="form-group">
                        <label><strong><?php echo e(__('Image')); ?> <small><?php echo e(__('(PNG format is standard)')); ?></small></strong></label>
                        <input type="file" name="image" class="form-control">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain'>
                                    <img id="image-preview" class="img-fluid" src="<?php echo e(asset('assets/images/gateway/'.$gateway->image)); ?>" alt="your image"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><strong><?php echo e(__('Name of Gateway')); ?></strong></label>
                                <input type="text" name="name" value="<?php echo e($gateway->name); ?>" id="name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><strong><?php echo e(__('Rate')); ?></strong></label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text">1 USD =</span>
                                    <input type="number" class="form-control" value="<?php echo e($gateway->rate); ?>" name="rate" step="any">
                                    <span class="input-group-text"><?php echo e($general->currency); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card--custom mb-3">
                                <div class="card-header bg-primary text-white"><strong><?php echo e(__('Deposit Limit')); ?></strong></div>
                                <div class="card-body">
                                    <label><strong><?php echo e(__('Minimum Amount')); ?></strong></label>
                                    <div class="input-group mb-3">
                                        <input type="number" step="any" class="form-control" value="<?php echo e($gateway->minimum_deposit_amount); ?>" name="minimum_deposit_amount">
                                        <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                    <label><strong><?php echo e(__('Maximum Amount')); ?></strong></label>
                                    <div class="input-group mb-3">
                                        <input type="number" step="any" name="maximum_deposit_amount" value="<?php echo e($gateway->maximum_deposit_amount); ?>" class="form-control">
                                        <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card--custom mb-3">
                                <div class="card-header bg-primary text-white"><strong><?php echo e(__('Deposit Charge')); ?></strong></div>
                                <div class="card-body">
                                    <label><strong><?php echo e(__('Fixed Charge')); ?></strong></label>
                                    <div class="input-group mb-3">
                                        <input type="number" step="any" class="form-control" value="<?php echo e($gateway->fixed_charge); ?>" name="fixed_charge">
                                        <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                    <label><strong><?php echo e(__('Charge in Percentage')); ?></strong></label>
                                    <div class="input-group mb-3">
                                        <input type="number" step="any" class="form-control" value="<?php echo e($gateway->percentage_charge); ?>" name="percentage_charge">
                                        <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><strong><?php echo e(__('Status')); ?></strong></label>
                                <select class="form-select" name="status">
                                    <option value="1" <?php echo e($gateway->status==1?'selected':''); ?>><?php echo e(__('Active')); ?></option>
                                    <option value="0" <?php echo e($gateway->status==0?'selected':''); ?>><?php echo e(__('Inactive')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($gateway->id > 69): ?>
                <div class="row">
                    <div class="col-xl-3">
                        <a href="javascript:void(0)" id="generate"
                           class="btn btn-primary mb-3"><?php echo e(__('Add Field option')); ?></a>
                    </div>

                    <div class="addOptions">
                        <?php $__currentLoopData = json_decode($gateway->field_options,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-4">
                                <div class="option-remove-row row">
                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="site-input-groups">
                                            <input name="field_options[<?php echo e($key); ?>][name]" class="box-input form-control"
                                                   type="text" value="<?php echo e($value['name']); ?>" required
                                                   placeholder="Field Name">
                                        </div>
                                    </div>

                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="site-input-groups">
                                            <select name="field_options[<?php echo e($key); ?>][type]"
                                                    class="form-select form-select-lg mb-3">
                                                <option value="text"
                                                        <?php if($value['type'] == 'text'): ?> selected <?php endif; ?>>Input
                                                    Text
                                                </option>
                                                <option value="textarea"
                                                        <?php if($value['type'] == 'textarea'): ?> selected <?php endif; ?>>
                                                    Textarea
                                                </option>
                                                <option value="file"
                                                        <?php if($value['type'] == 'file'): ?> selected <?php endif; ?>>File
                                                    upload
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="site-input-groups mb-0">
                                            <select name="field_options[<?php echo e($key); ?>][validation]"
                                                    class="form-select form-select-lg mb-1">
                                                <option value="required"
                                                        <?php if($value['validation'] == 'required'): ?> selected <?php endif; ?>>
                                                    Required
                                                </option>
                                                <option value="nullable"
                                                        <?php if($value['validation'] == 'nullable'): ?> selected <?php endif; ?>>
                                                    Optional
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <button class="delete-option-row delete_desc btn btn-danger" type="button">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('PAYMENT DETAILS')); ?></strong></label>
                    <textarea name="gateway_key_four" cols="30" rows="10" class="form-control"><?php echo e($gateway->gateway_key_four); ?></textarea>
                </div>
            <?php endif; ?>

            <?php if($gateway->id==1): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('PAYPAL API LIVE CLIENT ID')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('PAYPAL API LIVE CLIENT SECRET')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>

            <?php endif; ?>

            <?php if($gateway->id==2): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('COINPAYMENT MERCHANT ID')); ?></strong></label>
                    
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('COINPAYMENT SECRET')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>

            <?php if($gateway->id==3): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('STRIPE SECRET')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('STRIPE KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>

            <?php if($gateway->id==4): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('PAYFAST MERCHANT ID')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('PAYFAST MERCHANT KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>


            <?php if($gateway->id==5): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('Callback URL')); ?></strong></label>
                    <input type="text" value="<?php echo e(url('/')); ?>/paystack-payment/callback" class="form-control" readonly>
                    <p class="text-success"><small><?php echo e(__('Copy this link & save on your paystack portal (API Keys & Webhooks)')); ?></small></p>
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('PAYSTACK assets KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('PAYSTACK SECRET KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('MERCHANT EMAIL')); ?></strong></label>
                    <input type="text" name="gateway_key_three" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control">
                </div>
            <?php endif; ?>

            <?php if($gateway->id==6): ?>
            <div class="form-group">
                <label><strong><?php echo e(__('FLW assets KEY')); ?></strong></label>
                <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
            </div>

            <div class="form-group">
                <label><strong><?php echo e(__('FLW SECRET KEY')); ?></strong></label>
                <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
            </div>

            <div class="form-group">
                <label><strong><?php echo e(__('FLW SECRET HASH')); ?></strong></label>
                <input type="text" name="gateway_key_three" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control">
            </div>
            <?php endif; ?>


            <?php if($gateway->id==7): ?>
            <div class="form-group">
                <label><strong><?php echo e(__('PAYTM MERCHANT ID')); ?></strong></label>
                <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
            </div>

            <div class="form-group">
                <label><strong><?php echo e(__('PAYTM MERCHANT KEY')); ?></strong></label>
                <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
            </div>
            <?php endif; ?>

            <?php if($gateway->id==8): ?>
            <div class="form-group">
                <label><strong><?php echo e(__('Skrill EMAIL')); ?></strong></label>
                <input type="email" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
            </div>
            <?php endif; ?>
            <?php if($gateway->id==9): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('MERCHANT LOGIN ID')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><strong><?php echo e(__('MERCHANT TRANSACTION KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==10): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('API KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==11): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('API KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('AUTH TOKEN')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('API URL')); ?></strong></label>
                    <input type="text" name="gateway_key_three" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==12): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('assets KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('SECRET KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==13): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('API KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==14): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('API KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('SECRET KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>
            <?php if($gateway->id==15): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('PUBLISHABLE KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label><strong><?php echo e(__('PRIVATE KEY')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
            <?php endif; ?>


            <?php if($gateway->id==16): ?>
                <div class="form-group">
                    <label><strong><?php echo e(__('Razor Key')); ?></strong></label>
                    <input type="text" name="gateway_key_one" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control">
                </div>
                 <div class="form-group">
                    <label><strong><?php echo e(__('Razor Secret')); ?></strong></label>
                    <input type="text" name="gateway_key_two" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control">
                </div>
                
            <?php endif; ?>
            
            <div class="text-center mt-3">
                <button type="submit" class="btn s7__btn-primary me-2"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
        'use strict';

        if (null != <?php echo json_encode($gateway->field_options, 15, 512) ?>) {
            var i = Object.keys(JSON.parse(<?php echo json_encode($gateway->field_options, 15, 512) ?>)).length;
            $("#generate").on('click', function () {
                ++i;
                var form = `<div class="mb-4">
              <div class="option-remove-row row">
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <input name="field_options[` + i + `][name]" class="box-input form-control" type="text" value="" required placeholder="Field Name">
                  </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <select name="field_options[` + i + `][type]" class="form-select mb-3">
                        <option value="text">Input Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File upload</option>
                    </select>
                  </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups mb-0">
                    <select name="field_options[` + i + `][validation]" class="form-select mb-1">
                        <option value="required">Required</option>
                        <option value="nullable">Optional</option>
                    </select>
                  </div>
                </div>

                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                  <button class="delete-option-row delete_desc btn btn-danger" type="button">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
                </div>
              </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.option-remove-row').parent().remove();
            });
        }

    })(jQuery)

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/admin/gateway/edit.blade.php ENDPATH**/ ?>