
<?php $__env->startSection('title', __('Home')); ?>
<?php $__env->startSection('content'); ?>
    <section class="hn_about_section">
        <div class="container">
            <div class="row gy-4 align-items-center">
                <div class="col-lg-6">
                    <div class="hn_about_thumb">
                        <img src="<?php echo e(asset('assets/images/about/about_right_img.png')); ?>" alt="image">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hn_about_content">
                        <span class="hn_top_title border-right"><?php echo e(__($general->about_head)); ?></span>
                        <h2 class="hn_block_title"><?php echo e(__($general->about_title)); ?></h2>
                        <p class="fs-lg mt-3"><?php echo e(__($general->about_body)); ?></p>

                        <div class="mt-5">
                            <div class="row gy-5 hn_about_wrapper">
                                <div class="col-lg-12">
                                    <div class="hn_about_item">
                                        <div class="hn_about_item_icon">
                                            <img src="<?php echo e(asset('assets/images/about/one.png')); ?>" alt="icon image">
                                        </div>
                                        <div class="hn_about_item_content">
                                            <h4 class="title"><a
                                                    href="<?php echo e(route('single.page', ['class' => 'about_one'])); ?>"><?php echo e(__($general->single_about1_title)); ?></a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="hn_about_item">
                                        <div class="hn_about_item_icon">
                                            <img src="<?php echo e(asset('assets/images/about/two.png')); ?>" alt="icon image">
                                        </div>
                                        <div class="hn_about_item_content">
                                            <h4 class="title"><a
                                                    href="<?php echo e(route('single.page', ['class' => 'about_two'])); ?>"><?php echo e(__($general->single_about2_title)); ?></a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Plan Section -->
    <section class="hn_plan_section" style="background-image: url('assets/frontend/mediumpurple/images/plan-bg.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title border-left-right">INVESTMENT PLAN</span>
                        <h2 class="hn_block_title text-white">Check Our Valuable Plans</h2>
                    </div>
                </div>
            </div>

            <div>
                <ul class="nav nav-pills plan-tabs mb-4 justify-content-center" id="pills-tab" role="tablist">
                    <?php if(count($roi_plans)): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">
                            <?php echo e(__('ROI Investment')); ?>

                        </button>
                    </li>
                    <?php endif; ?>
                    <?php if(count($fixed_plans)): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">
                            <?php echo e(__('Fixed Investment')); ?>

                        </button>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="tab-content" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">
                <div class="row gy-4">
                    <?php $__currentLoopData = $roi_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="hn_plan">
                            <div class="hn_plan_top">
                                <span class="hn_plan_package_name text-white"><?php echo e(__($data->name)); ?></span>
                                <h3 class="hn_plan_price text-white mt-4"><?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?> <span><?php echo e(trans($getTime->name)); ?></span></h3>
                                <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-top.png')); ?>" alt="image"
                                    class="hn_plan_top_img">
                            </div>
                            <div class="hn_plan_body">
                                <ul class="hn_plan_feature_list">
                                    <li><i class="fa fa-check"></i> <?php echo e(__('Minimum Deposit')); ?> <?php echo e($data->min_amount); ?> <?php echo e($general->currency); ?></li>
                                    <li><i class="fa fa-check"></i> <?php echo e(__('Maximum Deposit')); ?> <?php echo e($data->max_amount); ?> <?php echo e($general->currency); ?></li>
                                    <li><i class="fa fa-check"></i> <?php echo e(__('ROI Action')); ?> <?php echo e($data->action); ?> <?php echo e(__('TIMES')); ?></li>
                                    <li><i class="fa fa-check"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                        <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                                </ul>
                                <a href="<?php echo e(route('invest.index')); ?>" class="btn hn_btn_solid_three border-0 w-100 mt-4"><?php echo e(__('Invest Now')); ?></a>
                                <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-body.png')); ?>" alt="image"
                                    class="hn_plan_body_img">
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
              <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab" tabindex="0">
                  <div class="row gy-4">
                    <?php $__currentLoopData = $fixed_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="hn_plan">
                            <div class="hn_plan_top">
                                <span class="hn_plan_package_name text-white"><?php echo e(__($data->name)); ?></span>
                                <h3 class="hn_plan_price text-white mt-4"><?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?> <span><?php echo e(trans($getTime->name)); ?></span></h3>
                                <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-top.png')); ?>" alt="image"
                                    class="hn_plan_top_img">
                            </div>
                            <div class="hn_plan_body">
                                <ul class="hn_plan_feature_list">
                                    <li><i class="fa fa-check"></i> <?php echo e(__('Deposit')); ?> <?php echo e($data->fixed_amount); ?><?php echo e($general->currency); ?></li>
                                    <li><i class="fa fa-check"></i> <?php echo e(__('ROI Action Lifetime TIMES')); ?></li>
                                    <li><i class="fa fa-check"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                        <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                                </ul>
                                <a href="<?php echo e(route('invest.index')); ?>" class="btn hn_btn_solid_three border-0 w-100 mt-4"><?php echo e(__('Invest Now')); ?></a>
                                <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-body.png')); ?>" alt="image"
                                    class="hn_plan_body_img">
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
    

            <div class="row gy-4 mt-5 justify-content-between align-items-center">
                <div class="col-lg-5">
                    <h2 class="hn_block_title text-white"><?php echo e(__('Profit Calculator')); ?></h2>
                    <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/calculator-chart.png')); ?>" alt="image"
                        class="mt-4 d-lg-block d-none">
                </div>
                <div class="col-lg-6">
                    <div class="hn_profit_calculator">
                        <form>
                            <div class="row gy-3 align-items-center">
                                <div class="col-lg-4">
                                    <label class="text-white"><?php echo e(__('Deposit Amount')); ?></label>
                                </div>
                                <div class="col-lg-8">
                                    <input type="number" id="investAmount" name="invest_amount" class="form-control" autocomplete="off">
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white"><?php echo e(__('Choose Plan')); ?></label>
                                </div>
                                <div class="col-lg-8">
                                    <select class="form-select planSelect">
                                        <option selected disabled><?php echo e(__('Select Plan')); ?></option>
                                        <?php $__currentLoopData = $roi_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>" planDetail="<?php echo e($data); ?>"><?php echo e(__($data->name)); ?> <?php switch($data->period):
                                                case (1): ?>
                                                <?php echo e(__('Hourly')); ?> <?php break; ?>
                                                <?php case (24): ?>
                                                <?php echo e(__('Daily')); ?> <?php break; ?>
                                                <?php case (168): ?>
                                                <?php echo e(__('Weekly')); ?> <?php break; ?>
                                                <?php case (720): ?>
                                                <?php echo e(__('Monthly')); ?> <?php break; ?>
                                                <?php case (2880): ?>
                                                <?php echo e(__('Quarterly')); ?> <?php break; ?>
                                                <?php case (8640): ?>
                                                <?php echo e(__('Yearly')); ?> <?php break; ?>
                                            <?php endswitch; ?> <?php echo e(__('Max')); ?>  <?php echo e($data->max_amount); ?> <?php echo e($general->currency); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white"><?php echo e(__('Profit Percent')); ?> (%)</label>
                                </div>
                                <div class="col-lg-8">
                                    <h4 class="text-white roiPerc">0</h4>
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white"><?php echo e(__('Total Revenue')); ?> (<?php echo e($general->currency); ?>)</label>
                                </div>
                                <div class="col-lg-8">
                                    <h4 class="text-white totalGetAmount">0</h4>
                                </div>
                            </div>
                            <button type="button" class="btn hn_btn_solid mt-4 w-100 subBtn"><i class="fas fa-calculator"></i>
                                <?php echo e(__('Calculate Profit')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_work_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__('OUR BEST SERVICES')); ?></span>
                        <h2 class="hn_block_title"><?php echo e(__('Your Path To Financial Prosperity')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row g-sm-4 g-3 justify-content-center">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-6">
                    <div class="hn_work_item">
                        <img src="<?php echo e(asset('assets/images/service/'.$data->icon)); ?>" alt="image">
                        <h3 class="hn_work_item_title"><?php echo e(__($data->title)); ?></h3>
                        <p class="mb-0"><?php echo e(__($data->description)); ?></p>
                        <span class="hn_work_number"><?php echo e($key+1); ?></span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <section class="hn_transaction_section"
        style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__('LATEST')); ?></span>
                        <h2 class="hn_block_title text-white"><?php echo e(__('Transaction')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4">
                <div class="col-xl-6">
                    <div class="hn_transaction_box">
                        <h3 class="hn_transaction_box_title"><?php echo e(__('Investments history')); ?></h3>
                        <ul class="hn_transaction_list">
                            <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <span><?php echo e($data->user->name); ?></span>
                                <span><?php echo e(__('Payment system')); ?> <strong class="fw-bold"><?php echo e($data->gateway->name); ?></strong></span>
                                <span><?php echo e(__('Amount')); ?> <strong class="fw-bold hn_transaction_amount"><?php echo e($data->usd_amo); ?> <?php echo e($general->currency); ?></strong></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="hn_transaction_box">
                        <h3 class="hn_transaction_box_title"><?php echo e(__('Withdrawals history')); ?></h3>
                        <ul class="hn_transaction_list">
                            <?php $__currentLoopData = $withdraw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <span><?php echo e($data->user->name); ?></span>
                                <span><?php echo e(__('Payment system')); ?> <strong class="fw-bold"><?php echo e($data->method_name); ?></strong></span>
                                <span><?php echo e(__('Amount')); ?> <strong class="fw-bold hn_transaction_amount"><?php echo e($data->amount); ?> <?php echo e($data->method_cur); ?></strong></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_investor_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__($general->investor_head)); ?></span>
                        <h2 class="hn_block_title"><?php echo e(__($general->investor_title)); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4">
                <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-sm-6">
                    <div class="hn_investor_item">
                        <div class="hn_investor_thumb">
                            <img src="<?php echo e(asset('assets/images/investor/'.$data->image)); ?>" alt="image">
                        </div>
                        <div class="hn_investor_content">
                            <h3 class="investor_name"><?php echo e(__($data->name)); ?></h3>
                            <p class="invest_amount"><?php echo e(__($data->designation)); ?></p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <section class="hn_choose_section" style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-4 col-sm-6">
                    <div class="hn_choose_item">
                        <img src="<?php echo e(asset('assets/images/work/'.$workAreaFirst->icon)); ?>" alt="image">
                        <h3 class="hn_choose_item_title"><a href="<?php echo e(route('single.page',['class' => 'work','id'=>$workAreaFirst->id])); ?>" class="text-white"><?php echo e(__($workAreaFirst->title)); ?></a></h3>
                        <p class="mb-0 mt-4 text-white"><?php echo e(__(short_text($workAreaFirst->description,25))); ?></p>
                    </div>
                </div>
                <?php $__currentLoopData = $workArea; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-sm-6">
                    <div class="hn_choose_item">
                        <img src="<?php echo e(asset('assets/images/work/'.$data->icon)); ?>" alt="image">
                        <h3 class="hn_choose_item_title"><a href="<?php echo e(route('single.page',['class' => 'work','id'=>$data->id])); ?>" class="text-white"><?php echo e(__($data->title)); ?></a></h3>
                        <p class="mb-0 mt-4 text-white"><?php echo e(__(short_text($data->description,25))); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    
    <section class="hn_faq_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__('FAQ')); ?></span>
                        <h2 class="hn_block_title"><?php echo e(__('Frequently Asked Questions')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="accordion hn_faq_accordion" id="accordionFaq">
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne<?php echo e($data->id); ?>">
                                    <button class="accordion-button <?php if($key == 0): ?> <?php else: ?> collapsed <?php endif; ?>" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne<?php echo e($data->id); ?>" aria-expanded="<?php if($key == 0): ?> true <?php else: ?> false <?php endif; ?>" aria-controls="collapseOne<?php echo e($data->id); ?>">
                                        <?php echo e(__($data->question)); ?>

                                    </button>
                                </h2>
                                <div id="collapseOne<?php echo e($data->id); ?>" class="accordion-collapse collapse <?php if($key == 0): ?> show <?php endif; ?>" aria-labelledby="headingOne<?php echo e($data->id); ?>" data-bs-parent="#accordionFaq">
                                    <div class="accordion-body">
                                        <p class="mb-0"><?php echo __($data->answer); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_affiliate_section"
        style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__('AFFILIATE')); ?></span>
                        <h2 class="hn_block_title text-white"><?php echo e(__('Our Refferal Comission')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-5">
                <div class="col-xl-12">
                    <div class="row gy-4">
                        <?php $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-6">
                            <div class="hn_referral_item">
                                <div class="hn_referral_item_level">
                                    <span><?php echo e($rank->title); ?></span>
                                </div>
                                <h3 class="hn_referral_amount"><?php echo e($rank->bonus); ?> <?php echo e($general->currency); ?></h3>
                                <p class="mb-0"><?php echo e(__('Referral Bonus')); ?></p>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_blog_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-10">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title"><?php echo e(__('LATEST NEWS')); ?></span>
                        <h2 class="hn_block_title"><?php echo e(__('News and articles')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="hn_blog_post">
                        <div class="hn_blog_thumb">
                            <img src="<?php echo e(asset('assets/images/news/'.$data->image)); ?>" alt="image">
                        </div>
                        <div class="hn_blog_content">
                            <span class="hn_blog_date"><?php echo e(date('F j, Y', strtotime($data->updated_at))); ?></span>
                            <ul class="hn_blog_meta">
                                <li><i class="far fa-user-circle"></i> <?php echo e(__('By Author')); ?></li>
                            </ul>
                            <h4 class="hn_blog_title">
                                <a href="<?php echo e(route('single.page',['class' => 'news', 'id' =>$data->id])); ?>"><?php echo e($data->title); ?></a>
                            </h4>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <input type="hidden" value="<?php echo e($general->cp_currency); ?>" id="cp_currency">
    <input type="hidden" value="<?php echo e($general->currency); ?>" id="currency">
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme . 'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\codecanyon-GTtFbtNC-investpro-wallet-banking-online-investment-platform\main-file_investpro\scripts\resources\views/theme/mediumpurple/frontend/index.blade.php ENDPATH**/ ?>