<?php $__env->startSection('title',__('Plans')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card mb-3">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Title & Subtitle'); ?></h4>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('general.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="form-group col-md-4 mb-2">
                        <label class="form-label"><?php echo app('translator')->get('Header Text'); ?></label>
                        <input type="text" class="form-control" name="invest_head" value="<?php echo e($general->invest_head); ?>">
                    </div>

                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Title Text'); ?></label>
                        <input type="text" class="form-control" name="invest_title" value="<?php echo e($general->invest_title); ?>">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Description Text'); ?></label>
                        <input type="text" class="form-control" name="invest_description" value="<?php echo e($general->invest_description); ?>">
                    </div>
                </div>
                <button type="submit" class="btn btn-primary mt-2"><?php echo app('translator')->get('Update'); ?></button>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Plan List'); ?> <a href="<?php echo e(route('plan-area.create')); ?>" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a> </h4>
        </div>

        <div class="card-body">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('Plan Name'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Return Percentage'); ?></th>
                    <th><?php echo app('translator')->get('Return Time'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($data->name); ?></td>
                    <td>
                        <?php if($data->return_time_status == 1): ?>
                            <?php echo e($data->min_amount); ?> <?php echo e($general->currency); ?> -- <?php echo e($data->max_amount); ?> <?php echo e($general->currency); ?>

                        <?php elseif($data->return_time_status == 2): ?>
                            <?php echo e($data->min_amount); ?> <?php echo e($general->cp_currency); ?> -- <?php echo e($data->max_amount); ?> <?php echo e($general->cp_currency); ?>

                        <?php elseif($data->return_time_status == 0): ?>
                            Fixed <?php echo e($data->fixed_amount); ?> <?php echo e($general->currency); ?>

                        <?php endif; ?>
                    </td>
                    <td><?php echo e($data->percent); ?>%</td>
                    <td>
                        <?php if(is_null($data->action)): ?>
                            <span class="badge bg-success"><?php echo app('translator')->get('LIFETIME'); ?></span>
                        <?php else: ?>
                            <?php echo e($data->action); ?> <?php echo app('translator')->get('TIMES'); ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('plan-area.edit', $data->id)); ?>" class="btn s7__btn-primary s7__bg-base btn-sm"><?php echo app('translator')->get('View/Edit'); ?></a>
                        <a href="#delModal" data-route="<?php echo e(route('plan-area.delete', $data->id)); ?>" data-bs-toggle="modal" class="btn btn-danger btn-sm editButton"><?php echo app('translator')->get('Delete'); ?></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>


    <div id="delModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Delete'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="confirmDel" role="form" action="" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>
                    <div class="modal-body">
                        <h2  class="text-danger"><?php echo app('translator')->get('Are you sure?'); ?></h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Delete'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/admin/plan/index.blade.php ENDPATH**/ ?>