
<?php $__env->startSection('title',__('Language Manager Edit')); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid" id="app">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="tile">
                    <div class="row">
                        <div class="col-md-8">
                            <h3 class="tile-title"> <?php echo e($page_title); ?> (<small><?php echo e(__('Click Add Translatable Add Put Your Key For Translate')); ?></small>)</h3>
                            <small class="red"><?php echo e(__('"Add Translatable Key" please careful when you entering word or sentences, there shouldn\'t be any extra space or break.')); ?> </small>
                            <small class="green"><?php echo e(__('If your keywords are perfect but translator doesn\'t work, don\'t worry. escape all dynamic keywords and add single word, it\'ll work.')); ?> </small>
                        </div>
                        <div class="col-md-4">
                            <form class="form-inline" method="post" @submit.prevent="importKey">
                                <div class="form-group mb-2">
                                    <select  class="form-select" required v-model="importData.code">
                                        <option value="">Import Keywords (Select Language)</option>
                                        <?php $__currentLoopData = $list_lang; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>" <?php if($data->id == $la->id): ?> style="display: none" <?php endif; ?>><?php echo e($data->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mb-2">Import Now</button>
                            </form>
                            <small class="red">If you import keywords from another language, Your present "<?php echo e($la->name); ?>" all keywords will remove.</small>
                        </div>
                    </div>
                    <hr>
                    <div class="tile-body" style="overflow: hidden">
                        <form class="form-cont" method="post" action="<?php echo e(route('key-update', $la->id)); ?>" id="langForm">
                            <?php echo e(csrf_field()); ?>

                            <?php echo e(method_field('put')); ?>

                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-3 mb-2" v-for="(value, key) in datas" :key="key">
                                        <label class="control-label">{{ key }}</label>
                                        <div class="input-group">
                                            <input type="text" :value="value" :name="'keys[' + key + ']'" class="form-control">
                                            <span class="input-group-text input_group_col" @click.prevent="deleteElement(key)"><i class="fa fa-trash"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <br>
                                <div class="row mb-2">
                                    <div class="col-md-12 text-center">
                                        <button type="button" data-bs-toggle="modal" data-bs-target="#addModal" class="btn btn-primary"><?php echo e(__('Add Translatable Key')); ?></button>
                                        <button class="btn btn-success" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Save'); ?>" @click.prevent="save"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <button class="btn btn-primary btn-block"><i class="fa fa-send"></i> <?php echo e(__('Update')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Modal title')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class="form-cont" id="newlangForm">
                    <div class="modal-body">
                        <div class="form-group mb-2">
                            <label for="exampleInputEmail1"><?php echo e(__('English')); ?></label>
                            <input type="text" class="form-control" v-model="newKey" required>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputPassword1"><?php echo e($la->name); ?></label>
                            <input type="text" class="form-control" v-model="newVal" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="submit" class="btn btn-primary" value="Add Field" @click.prevent="addfield()">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.18.0/axios.js"></script>

<script>
        window.Laravel = <?php echo json_encode([
        'csrfToken' => csrf_token(),
    ]); ?>;
    </script>

    <script>
        window.app = new Vue({
            el: '#app',
            data: {
                datas: <?php echo $json; ?>,
                current: '<?php echo e($la->code); ?>',
                newVal: null,
                newKey: null,


                importData : {
                    code : ''
                }

            },
            methods: {
                save() {
                    $('#langForm').submit();
                },

                deleteElement(key) {
                    Vue.delete(this.datas, key);
                },
                addfield() {
                    Vue.set(this.datas, this.newKey, this.newVal);
                    app.newKey = '';
                    app.newVal = '';
                    $("#addModal").modal('hide');
                },
                importKey()
                {
                    var code = this.importData;
                    axios.post('<?php echo e(route('import_lang')); ?>', code).then(function (res) {
                        app.datas = res.data;
                    })

                }
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\main-file_investpro\investpro\scripts\resources\views/lang/edit_lang.blade.php ENDPATH**/ ?>