
<?php $__env->startSection('title', __('Identity Form')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card mb-3">
        <div class="card-body">
            <form method="post" action="<?php echo e(route('general.store')); ?>" class="form-row align-items-center ">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="form-group col-md-3">
                        <label class="d-block"><?php echo app('translator')->get('Identity Verification'); ?></label>
                        <div class="onOff-radio-field">
                            <div class="onOff-radio-option">
                                <input type="radio" name="identity_verification" id="identity_verification" value="1"
                                    <?php if ($general->identity_verification == 1):
                                        echo 'checked';
                                    endif; ?>>
                                <label class="bgc-success" for="identity_verification">ON</label>
                            </div>

                            <div class="onOff-radio-option">
                                <input type="radio" name="identity_verification" id="identity_verification1"
                                    value="0" <?php if ($general->identity_verification == 0):
                                        echo 'checked';
                                    endif; ?>>
                                <label class="bgc-danger" for="identity_verification1">OFF</label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <button type="submit" class="btn s7__btn-primary s7__bg-base text-white mx-2 mt-4">
                            <span><?php echo app('translator')->get('Submit'); ?></span></button>
                    </div>
                </div>

            </form>
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <?php
                $newArr = ['Driving License', 'Passport', 'National ID'];
            ?>
            <?php if(count($formExist) != count($newArr)): ?>
                <h4 class="card-title"><?php echo app('translator')->get('Identity Form'); ?> <button data-bs-toggle="modal" data-bs-target="#btn_add"
                        type="button" class="btn s7__btn-primary s7__bg-base float-end"><i class="fa fa-plus-circle"></i>
                        <?php echo e(trans('Add Form')); ?> </button></h4>
            <?php endif; ?>
        </div>
        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo app('translator')->get('Identity Type'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($data->name); ?></td>
                            <td>
                                <span
                                    class="badge bg-<?php echo e($data->status == 0 ? 'danger' : 'success'); ?>"><?php echo e($data->status == 0 ? 'Inactive' : 'Active'); ?></span>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                <a href="<?php echo e(route('identify-form.edit', $data->id)); ?>"
                                    class="btn s7__btn-primary s7__bg-base text-white btn-sm"><i class="fa fa-edit"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="modal fade" id="btn_add" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="myModalLabel"><i class="fa fa-plus-circle"></i>
                            <?php echo e(trans('Add New')); ?></h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row ">
                            <div class="col-md-6 form-group">
                                <label for="inputName"><strong><?php echo e(trans('Identity Type')); ?> :</strong></label>
                                <select class="form-select w-100" data-live-search="true" name="name" required="">
                                    <option disabled selected><?php echo app('translator')->get('Select Type'); ?></option>
                                    <?php if(!in_array('Driving License', $formExist)): ?>
                                        <option value="Driving License"><?php echo e(trans('Driving License')); ?></option>
                                    <?php endif; ?>
                                    <?php if(!in_array('Passport', $formExist)): ?>
                                        <option value="Passport"><?php echo e(trans('Passport')); ?></option>
                                    <?php endif; ?>
                                    <?php if(!in_array('National ID', $formExist)): ?>
                                        <option value="National ID"><?php echo e(trans('National ID')); ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="inputName" class="d-block"><strong><?php echo e(trans('Status')); ?>

                                        :</strong></label>

                                <select class="form-select w-100" data-live-search="true" name="status" required="">
                                    <option disabled selected><?php echo app('translator')->get('Select Status'); ?></option>
                                    <option value="1"><?php echo e(trans('Active')); ?></option>
                                    <option value="0"><?php echo e(trans('Deactive')); ?></option>
                                </select>
                            </div>

                            <div class="col-md-12 form-group">
                                <br>
                                <a href="javascript:void(0)" class="btn btn-success btn-sm float-end generate"><i
                                        class="fa fa-plus-circle"></i> <?php echo e(trans('Add Field')); ?></a>

                            </div>
                        </div>

                        <div class="row addedField mt-3">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e(trans('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('Submit')); ?></button>
                    </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="myModalLabel"><i class="fa fa-plus-circle"></i>
                            <?php echo e(trans('Update Identity Form')); ?></h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row ">
                            <div class="col-md-6 form-group ">
                                <label for="inputName" class="control-label d-block"><strong><?php echo e(trans('Status')); ?>

                                        :</strong></label>
                                <select class="form-select  w-100 edit_status" data-live-search="true" name="status"
                                    required="">
                                    <option disabled><?php echo app('translator')->get('Select Status'); ?></option>
                                    <option value="1"><?php echo e(trans('Active')); ?></option>
                                    <option value="0"><?php echo e(trans('Deactive')); ?></option>
                                </select>
                                <br>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e(trans($message)); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6 form-group">
                                <br>
                                <a href="javascript:void(0)" class="btn btn-success btn-sm float-right generate"><i
                                        class="fa fa-plus-circle"></i> <?php echo e(trans('Add Field')); ?></a>

                            </div>
                        </div>

                        <div class="row addedField mt-3">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e(trans('Close')); ?></button>
                        <button type="submit" class="btn s7__btn-primary s7__bg-base"><?php echo e(trans('Update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
        $(document).ready(function() {

            $(".generate").on('click', function() {
                var form = `<div class="col-md-12 mb-3">
                                 <div class="card border-primary">
                                        <div class="card-header  bg-primary p-2 d-flex justify-content-between">
                                            <h5 class="card-title text-white font-weight-bold"><?php echo e(trans('Field information')); ?></h3>
                                            <button  class="btn  btn-danger btn-sm delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-4 form-group">
                                                    <label><?php echo e(trans('Field Name')); ?></label>
                                                    <input name="field_name[]" class="form-control " type="text" value="" required
                                                           placeholder="<?php echo e(trans('Field Name')); ?>">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Form Type')); ?></label>
                                                    <select name="type[]" class="form-select">
                                                        <option value="text"><?php echo e(trans('Input Text')); ?></option>
                                                        <option value="textarea"><?php echo e(trans('Textarea')); ?></option>
                                                        <option value="file"><?php echo e(trans('File upload')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Field Length')); ?></label>
                                                    <input name="field_length[]" class="form-control " type="number" min="2" value="" required
                                                           placeholder="<?php echo e(trans('Length')); ?>">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Field Length Type')); ?></label>
                                                    <select name="length_type[]" class="form-select">
                                                        <option value="max"><?php echo e(trans('Maximum Length')); ?></option>
                                                        <option value="digits"><?php echo e(trans('Fixed Length')); ?></option>
                                                    </select>
                                                </div>



                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Form Validation')); ?></label>
                                                    <select name="validation[]" class="form-select">
                                                        <option value="required"><?php echo e(trans('Required')); ?></option>
                                                        <option value="nullable"><?php echo e(trans('Optional')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                            </div> `;

                $('.addedField').append(form)
            });

            $('select').select2({
                width: '100%'
            });


            $(document).on('click', '.editButton', function(e) {
                $('.addedField').html('')

                var obj = $(this).data()
                $('.edit_id').val(obj.id)
                $('.edit_name').val(obj.name).trigger('change');
                $(".edit_status").val(obj.status).trigger('change');
                $(".edit_service_id").val(obj.service_id).trigger('change');

                if (obj.services_form == 'null') {

                } else {
                    var objData = Object.entries(obj.services_form);

                    var form = '';
                    for (let i = 0; i < objData.length; i++) {
                        form += `<div class="col-md-12 mb-3">

                                    <div class="card border-primary">

                                        <div class="card-header  bg-primary p-2 d-flex justify-content-between">
                                            <h5 class="card-title text-white font-weight-bold"><?php echo e(trans('Field information')); ?></h3>
                                            <button  class="btn  btn-danger btn-sm delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>

                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-4 form-group">
                                                    <label><?php echo e(trans('Field Name')); ?></label>
                                                    <input name="field_name[]" class="form-control"
                                                     value="${objData[i][1].field_level}"
                                                     type="text" required
                                                           placeholder="<?php echo e(trans('Field Name')); ?>">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Form Type')); ?></label>
                                                    <select name="type[]" class="form-select">
                                                        <option value="text" ${(objData[i][1].type === 'text' ? 'selected="selected"' : '')}><?php echo e(trans('Input Text')); ?></option>
                                                        <option value="textarea" ${(objData[i][1].type === 'textarea' ? 'selected="selected"' : '')}><?php echo e(trans('Textarea')); ?></option>
                                                        <option value="file" ${(objData[i][1].type === 'file' ? 'selected="selected"' : '')}><?php echo e(trans('File upload')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Field Length')); ?></label>
                                                    <input name="field_length[]" class="form-control " type="number" min="2" required
                                                    value="${objData[i][1].field_length}"
                                                           placeholder="<?php echo e(trans('Length')); ?>">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Field Length Type')); ?></label>
                                                    <select name="length_type[]" class="form-select">
                                                        <option value="max"  ${(objData[i][1].length_type === 'max' ? 'selected="selected"' : '')}><?php echo e(trans('Maximum Length')); ?></option>
                                                        <option value="digits"  ${(objData[i][1].length_type === 'digits' ? 'selected="selected"' : '')}><?php echo e(trans('Fixed Length')); ?></option>
                                                    </select>
                                                </div>



                                                <div class="col-md-2 form-group">
                                                    <label><?php echo e(trans('Form Validation')); ?></label>
                                                    <select name="validation[]" class="form-select">
                                                            <option value="required" ${(objData[i][1].validation === 'required' ? 'selected="selected"' : '')}><?php echo e(trans('Required')); ?></option>
                                                            <option value="nullable" ${(objData[i][1].validation === 'nullable' ? 'selected="selected"' : '')}><?php echo e(trans('Optional')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> `;
                    }
                    $('.addedField').append(form)
                }
            });

            $(document).on('click', '.delete_desc', function() {
                $(this).closest('.card').parent().remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/admin/identify/services.blade.php ENDPATH**/ ?>