
<?php $__env->startSection('title',__('Language Manager')); ?>
<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <h2><a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a> </h2>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo app('translator')->get('Name'); ?></th>
                        <th><?php echo app('translator')->get('Code'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $lang_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="row1">
                        <td><?php echo e($key+1); ?></td>
                        <td><?php echo e($data->name); ?></td>
                        <td><?php echo e($data->code); ?></td>
                        <td>
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('language-key', $data->id)); ?>"><i class="fa fa-code"></i><?php echo app('translator')->get('Keyword Edit'); ?></a>
                            <a class="btn btn-primary btn-sm" href="#editModal1<?php echo e($data->id); ?>" data-bs-toggle="modal"><?php echo app('translator')->get('Edit'); ?></a>
                            <button type="button" class="btn btn-danger btn-sm bold uppercase delete_button" data-bs-toggle="modal" data-bs-target="#delModal<?php echo e($data->id); ?>"><?php echo app('translator')->get('Delete'); ?></button>
                        </td>
                    </tr>

                <div id="editModal1<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo app('translator')->get('Edit'); ?> <?php echo e($data->name); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form class="form-cont" role="form" method="post" action="<?php echo e(route('language-manage-update', $data->id)); ?>">
                                <div class="modal-body">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="control-label"><?php echo app('translator')->get('Language Name'); ?></label>
                                            <input class="form-control text-capitalize" value="<?php echo e($data->name); ?>" id="code" type="text" required name="name">
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" id="btn-save" data-bs-dismiss="modal" class="btn btn-danger"><?php echo app('translator')->get('Cancel'); ?></button>
                                    <button type="submit" class="btn btn-success"> <?php echo app('translator')->get('Update'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div id="delModal<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo app('translator')->get('Confirm Delete'); ?> <?php echo e($data->name); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <h2 class="text-danger"><?php echo app('translator')->get('Are you sure?'); ?></h2>
                            </div>
                            <form class="form-cont" id="confirmDel" role="form" action="<?php echo e(route('language-manage-del', $data->id)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('delete'); ?>
                                <div class="modal-footer">
                                    <input type="hidden" name="delete_id" id="delete_id" class="delete_id" value="0">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                    <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Delete'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>     
                </tbody>
            </table>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add New Language'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class="form-cont" role="form" method="post" action="<?php echo e(route('language-manage-store')); ?>">
                    <div class="modal-body">
                        <?php echo e(csrf_field()); ?>

                        <div class="row mb-2">
                            <div class="col-md-12">
                                <label class="control-label"><?php echo app('translator')->get('Language Name'); ?></label>
                                <input class="form-control text-capitalize" id="code" type="text" required name="name">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <label class="control-label"><?php echo app('translator')->get('Language Code'); ?></label>
                                <input class="form-control text-capitalize" id="link" type="text" required name="code">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" data-bs-dismiss="modal" class="btn btn-danger"><?php echo app('translator')->get('Cancel'); ?></button>
                        <button type="submit" id="btn-save" class="btn btn-primary"> <?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\main-file_investpro\investpro\scripts\resources\views/lang/lang.blade.php ENDPATH**/ ?>