<?php $__env->startSection('title', __('Deposit Preview')); ?>
<?php $__env->startSection('content'); ?>
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <form method="POST" action="<?php echo e(route('deposit.confirm')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="gateway" value="<?php echo e($data->gateway_id); ?>"/>
                        <?php if($data->gateway_id > 899): ?>
                            <input type="hidden" name="depositid" value="<?php echo e($data->id); ?>"/>
                            <input type="hidden" name="drid" value="<?php echo e($dr->id); ?>"/>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="thumb mb-4 align-self-center">
                                    <img src="<?php echo e(asset('assets/images/gateway')); ?>/<?php echo e($data->gateway->image); ?>" alt="icon">
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="facility-details card">
                                    <div class="card-body">
                                        <h5 class="text-dark">Amount : <?php echo e($data->amount); ?>

                                            <strong><?php echo e($general->currency); ?></strong></h5>
                                        <p class="list-group-item"> <?php echo e(__('Charge')); ?> :
                                            <strong><?php echo e($data->charge); ?> </strong><?php echo e($general->currency); ?></p>
                                        <p class="list-group-item "> <?php echo e(__('Payable')); ?> :
                                            <strong><?php echo e($data->charge + $data->amount); ?> </strong><?php echo e($general->currency); ?></p>
    
                                        <p class="list-group-item"> <?php echo e(__('In USD')); ?> :
                                            <strong>$<?php echo e($data->usd_amo); ?></strong>
                                        </p>
                                    </div>
                                </div>
                                <div class="col-12 text-center mt-3 mb-3">
                                    <input type="submit" class="btn btn-base border-radius-5 pe-5 ps-5" id="btn-confirm" value="<?php echo e(__('Pay Now')); ?>">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/theme/mediumpurple/user/deposit/preview.blade.php ENDPATH**/ ?>