<?php $__env->startSection('title', __('Add Fund')); ?>
<?php $__env->startSection('content'); ?>
<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9 col-md-8">
                <div class="stepwizard">
                    <div class="stepwizard-row setup-panel">
                        <div class="stepwizard-step col-xs-3">
                            <a href="#step-1" type="button" class="btn btn-success btn-circle">1</a>
                        <p><small><?php echo e(__('Amount')); ?></small></p>
                        </div>
                        <div class="stepwizard-step col-xs-3">
                            <a href="#step-2" type="button" class="btn btn-secondary btn-circle" disabled="disabled">2</a>
                        <p><small><?php echo e(__('Gateway')); ?></small></p>
                        </div>
                    </div>
                </div>
                <form role="form" method="POST" action="<?php echo e(route('submit.amount.deposit')); ?>" id="submitPayment" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="contact-page-inner bg-black-2 contact-page-inner-cust setup-content rounded-3" id="step-1">
                        <div class="section-title mb-4 pb-2 text-center">
                            <h2 class="title text-white"><?php echo e(__('Put Your Deposit Amount')); ?> </h2>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label class="control-label text-white"><?php echo e(__('Amount')); ?></label>
                                    <input maxlength="100" type="text" class="form-control border" required="required" autocomplete="off" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount"  id="amount" placeholder="<?php echo e(__('AMOUNT')); ?>" />
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="button" class="btn btn-base border-radius-5 pe-5 ps-5 nextBtn"><?php echo e(__('Next')); ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="payment-area pd-top-120 pd-bottom-220 setup-content" id="step-2">
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-lg-12 align-self-center">
                                    <div class="single-payment-wrap pe-xl-5 px-xl-5 rounded-3">
                                        <div class="row gy-4">
                                            <div class="col-lg-12 text-center">
                                                <h2 class="mb-5 mt-4 text-white"><?php echo e(__('Select Payment Gateway')); ?></h2>
                                            </div>
                                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-4 col-md-6">
                                                <div class="payment-gateway-check form-check">
                                                    <div class="ps-4">
                                                        <input class="form-check-input" type="radio" name="gateway" id="customRadio<?php echo e($gate->id); ?>" data-valFour="<?php echo $gate->gateway_key_four; ?>" data-valFive="<?php echo e($gate->name); ?>" value="<?php echo e($gate->id); ?>">
                                                    </div>
                                                    <label class="form-check-label" for="customRadio<?php echo e($gate->id); ?>">
                                                        <div class="ps-5">
                                                            <h6><?php echo e(__($gate->name)); ?></h6>
                                                        </div>
                                                      <img src="<?php echo e(asset('assets/images/gateway/'.$gate->image)); ?>" alt="img">
                                                      <p class="text-success mb-2"><?php echo e(__('Min-Max')); ?> :<?php echo e($gate->minimum_deposit_amount); ?> - <?php echo e($gate->maximum_deposit_amount); ?> <?php echo e($general->currency); ?></p>
                                                      <p class="text-danger mb-0"><?php echo e(__('Fixed Charge')); ?> : <?php echo e($gate->fixed_charge); ?> <?php echo e($general->currency); ?> & <?php echo e(__('Percentage Charge')); ?> : <?php echo e($gate->percentage_charge); ?>%</p>
                                                    </label>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-12 text-center">
                                                <button class="btn btn-base mt-4 mb-4 subPre" type="button"><?php echo e(__('Submit & Preview')); ?></button>
                                            </div>
                                        </div>  
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="depositModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title text-white gateWayFive" id="exampleModalLabel"><?php echo e(__('Deposit via')); ?></h5>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="post" action="<?php echo e(route('submit.amount.deposit')); ?>" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <strong class="text-white"><?php echo e(__('Payment Details')); ?></strong> <small><?php echo e(__('(Send Here)')); ?></small><br>
                                        <div class="gateWayFour text-white">
                        
                                        </div>

                                        <div class="row manual-row">
                                            
                                        </div>
                                        
                                        
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><?php echo e(__('Preview')); ?></button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    </div>
                                </form>
                              </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
         (function($) {
            "use strict";
        $(".subPre").on('click',function() {
            document.getElementById('submitPayment').submit();
        });


        $(document).ready(function () {
            $(".form-check-input").change(function() {
                if(this.checked && $(this).val() > 69) {
                    $('#depositModal').modal('show');
                    $('.gateWayFour').html($(this).attr('data-valFour'));
                    $('.gateWayFive').html($(this).attr('data-valFive'));
                }
            });

            var navListItems = $('div.setup-panel div a'),
                allWells = $('.setup-content'),
                allNextBtn = $('.nextBtn');

            allWells.hide();

            navListItems.click(function (e) {
                e.preventDefault();
                var $target = $($(this).attr('href')),
                    $item = $(this);

                if (!$item.hasClass('disabled')) {
                    navListItems.removeClass('btn-success').addClass('btn-secondary');
                    $item.addClass('btn-success');
                    allWells.hide();
                    $target.show();
                    $target.find('input:eq(0)').focus();
                }
            });

            allNextBtn.click(function () {
                var curStep = $(this).closest(".setup-content"),
                    curStepBtn = curStep.attr("id"),
                    nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
                    curInputs = curStep.find("input[type='text'],input[type='url']"),
                    isValid = true;

                $(".form-group").removeClass("has-error");
                for (var i = 0; i < curInputs.length; i++) {
                    if (!curInputs[i].validity.valid) {
                        isValid = false;
                        $(curInputs[i]).closest(".form-group").addClass("has-error");
                    }
                }

                if (isValid) nextStepWizard.removeAttr('disabled').trigger('click');
            });

            $('div.setup-panel div a.btn-success').trigger('click');
        });

    })(jQuery);

    </script>


<script>
    var globalData;
    $(".form-check-input").on('change', function (e) {

        "use strict"
        e.preventDefault();
        $('.manual-row').empty();
        var code = $(this).val()
        var url = '<?php echo e(route("user.deposit.gateway",":code")); ?>';
        url = url.replace(':code', code);
        $.get(url, function (data) {
            globalData = data;
            if (data.credentials !== undefined) {
                $('.manual-row').append(data.credentials)
            }

        });

    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/theme/mediumpurple/user/deposit/deposit.blade.php ENDPATH**/ ?>