
<?php $__env->startSection('title',__('Manage Theme')); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <?php $__currentLoopData = $theme; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-header bg-dark p-3 text-white my-1 font-weight-bold">
                        <?php echo e($data['title']); ?>

                    </div>
                    <div class="card-body">
                        <img class="w-100" src="<?php echo e(asset($data['path'])); ?>" alt="<?php echo app('translator')->get('theme-image'); ?>" >
                    </div>
                    <div class="card-footer">
                        <?php if($general->theme == $key): ?>
                            <button
                                type="button"
                                disabled
                                class="btn btn-rounded btn-success btn-block mt-3">
                                <span><i class="fas fa-check-circle pr-2"></i> <?php echo app('translator')->get('Active'); ?></span>
                            </button>
                        <?php else: ?>
                            <button
                                type="button"
                                class="btn btn-rounded btn-danger btn-block mt-3 activateBtn"
                                data-bs-toggle="modal" data-bs-target="#activateModal"
                                data-route="<?php echo e(route('activate.themeUpdate', $key)); ?>">
                                <span><i class="fas fa-save pr-2"></i> <?php echo app('translator')->get('Inactive'); ?></span>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</div>

<div id="activateModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Theme Activate Confirmation'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo app('translator')->get('Are you sure to activate this theme?'); ?></p>
            </div>
            <form action="" method="post" class="actionForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Activate'); ?></button>
                </div>

            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
        $(document).ready(function () {

            $('.activateBtn').on('click', function () {
                $('.actionForm').attr('action', $(this).data('route'));
            })

            $('select').select2({
                selectOnClose: true
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mrsen07/invesproupdate.wowtheme7.com/scripts/resources/views/admin/general/manage_theme.blade.php ENDPATH**/ ?>