<?php $__env->startSection('title',__('Plan')); ?>
<?php $__env->startSection('content'); ?>

<section class="hn_plan_section">
    <div class="container">

        <div>
            <ul class="nav nav-pills plan-tabs mb-4 justify-content-center" id="pills-tab" role="tablist">
                <?php if(count($roi_plans)): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">
                        <?php echo e(__('ROI Investment')); ?>

                    </button>
                </li>
                <?php endif; ?>
                <?php if(count($fixed_plans)): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">
                        <?php echo e(__('Fixed Investment')); ?>

                    </button>
                </li>
                <?php endif; ?>
            </ul>
        </div>
        <div class="tab-content" id="pills-tabContent">
          <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">
            <div class="row gy-4">
                <?php $__currentLoopData = $roi_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                ?>
                <div class="col-lg-4 col-md-6">
                    <div class="hn_plan">
                        <div class="hn_plan_top">
                            <span class="hn_plan_package_name text-white"><?php echo e(__($data->name)); ?></span>
                            <h3 class="hn_plan_price text-white mt-4"><?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?> <span><?php echo e(trans($getTime->name)); ?></span></h3>
                            <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-top.png')); ?>" alt="image"
                                class="hn_plan_top_img">
                        </div>
                        <div class="hn_plan_body">
                            <ul class="hn_plan_feature_list">
                                <li><i class="fa fa-check"></i> <?php echo e(__('Minimum Deposit')); ?> <?php echo e($data->min_amount); ?> <?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-check"></i> <?php echo e(__('Maximum Deposit')); ?> <?php echo e($data->max_amount); ?> <?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-check"></i> <?php echo e(__('ROI Action')); ?> <?php echo e($data->action); ?> <?php echo e(__('TIMES')); ?></li>
                                <li><i class="fa fa-check"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                    <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                            </ul>
                            <button data-all="<?php echo e($data); ?>" data-route="<?php echo e(route('purchase.plan',$data->id)); ?>" data-bs-target="#addModal" data-bs-toggle="modal" class="btn hn_btn_solid_three border-0 w-100 mt-4 investRoi"><?php echo e(__('Invest Now')); ?></button>
                            <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-body.png')); ?>" alt="image"
                                class="hn_plan_body_img">
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
          <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab" tabindex="0">
              <div class="row gy-4">
                <?php $__currentLoopData = $fixed_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                ?>
                <div class="col-lg-4 col-md-6">
                    <div class="hn_plan">
                        <div class="hn_plan_top">
                            <span class="hn_plan_package_name text-white"><?php echo e(__($data->name)); ?></span>
                            <h3 class="hn_plan_price text-white mt-4"><?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?> <span><?php echo e(trans($getTime->name)); ?></span></h3>
                            <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-top.png')); ?>" alt="image"
                                class="hn_plan_top_img">
                        </div>
                        <div class="hn_plan_body">
                            <ul class="hn_plan_feature_list">
                                <li><i class="fa fa-check"></i> <?php echo e(__('Deposit')); ?> <?php echo e($data->fixed_amount); ?><?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-check"></i> <?php echo e(__('ROI Action Lifetime TIMES')); ?></li>
                                <li><i class="fa fa-check"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                    <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                            </ul>
                            <a href="#addModalTwo" data-bs-toggle="modal" data-all="<?php echo e($data); ?>"  data-route="<?php echo e(route('purchase.plan',$data->id)); ?>" class="investFixed btn hn_btn_solid_three border-0 w-100 mt-4"><?php echo e(__('Invest Now')); ?></a>
                            <img src="<?php echo e(asset('assets/frontend/mediumpurple/images/plan-body.png')); ?>" alt="image"
                                class="hn_plan_body_img">
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
        </div>
    </div>
</section>


<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white roiTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlan" action="" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <h6 class="text-success text-center totalGetAmount"></h6>
                <p class="text-primary text-center roiMsg"></p>
                <div class="form-row">
                    <div class="input-group col-md-12">
                        <input type="text" class="form-control" id="investAmount" name="invest_amount" placeholder="<?php echo e(__('Put Amount for invest')); ?>" autocomplete="off">
                        <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                    </div>
                </div>
                <p class="text-danger text-center roiMinMax"></p>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success submitBtn"><?php echo e(__('Submit')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>


<div class="modal fade" id="addModalTwo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white fixTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlanTwo" action="" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <h6 class="text-danger text-center tAmountFix"></h6>
                <h5 class="text-success text-center totalGetAmountFix"></h5>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><?php echo e(__('Submit')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
        $(document).ready(function () {
            $('.submitBtn').css('display','none');
            $('.investFixed').on('click',function () {
                $('#purPlanTwo').attr('action',$(this).data('route'));
                let retuenPerFix = $(this).data('all')['percent'];
                let amtFix = $(this).data('all')['fixed_amount'];
                $('.fixTitle').text($(this).data('all')['name']);
                $('.tAmountFix').text(amtFix+' <?php echo e($general->currency); ?> will deduct from your balance');
                $('.totalGetAmountFix').text('You will get '+retuenPerFix+'% of your Invest for Lifetime');
            });

            $('.investRoi').on('click',function () {
                $('#purPlan').attr('action',$(this).data('route'));
                $('#investAmount').val('');
                getBlank();
                let minAmount = $(this).data('all')['min_amount'];
                let maxAmount = $(this).data('all')['max_amount'];
                let retuenPer = $(this).data('all')['percent'];
                let retuenAction = $(this).data('all')['action'];
                $('.roiTitle').text($(this).data('all')['name']);
                $('.roiMinMax').text('Minimum '+minAmount+' <?php echo e($general->currency); ?> - Maximum '+maxAmount+'<?php echo e($general->currency); ?>');
                $('#investAmount').on('keyup',function () {
                    let invAmount = this.value;
                    if ((parseFloat(invAmount) >= parseFloat(minAmount)) && (parseFloat(invAmount) <= parseFloat(maxAmount))) {
                        let returnAmt = (parseFloat(invAmount)*parseFloat(retuenPer))/100;
                        let totalGetAmount = parseFloat(returnAmt)*parseFloat(retuenAction);
                        $('.roiMsg').text('You will get '+returnAmt+' <?php echo e($general->currency); ?> for '+retuenAction+' times');
                        $('.totalGetAmount').text('You will get total '+totalGetAmount+' <?php echo e($general->currency); ?> after complete ROI');
                        $('.submitBtn').css('display','block');
                    }else {
                        $('.submitBtn').css('display','none');
                        getBlank();
                    }
                })
            });
            function getBlank() {
                $('.roiMsg').text('');
                $('.totalGetAmount').text('');
            }
        });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mrsen07/invesproupdate.wowtheme7.com/scripts/resources/views/theme/mediumpurple/user/invest/plan.blade.php ENDPATH**/ ?>