<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title><?php echo e($general->web_name); ?> | <?php echo $__env->yieldContent('title', __('Admin Login')); ?></title>
        <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>" sizes="16x16" />
        <?php echo $__env->make('admin.layouts.partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('style'); ?>
    </head>
    <body>

      <div class="auth-page">
        <div class="container">
          <div class="row auth-card justify-content-center">
              <div class="col-lg-6 col-md-5 align-self-center">
                  <img src="<?php echo e(asset('assets/images/login.png')); ?>" alt="img">
              </div>
              <div class="col-lg-6 col-md-7">
                  <div class="text-center mb-3">
                    <a href="<?php echo e(url('/')); ?>" class="auth-logo"><img src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="logo"></a>
                    <h3 class="mt-3"><?php echo e(__('Admin Login')); ?></h3>
                  </div>
                  <form id="myForm" role="form" action="<?php echo e(route('admin.login')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                      <input type="email" class="form-control" placeholder="Email Address" name="email" value="<?php echo e(old('email')); ?>" autofocus>
                    </div>
                    <div class="mb-3">
                      <input type="password" class="form-control" placeholder="Password" name="password">
                    </div>
                    <?php if($general->g_captcha == 1): ?>
                      <div class="form-group mb-3">
                          <div class="col-md-12">
                              <div class="g-recaptcha" data-sitekey="<?php echo e($general->captcha_key_one); ?>"></div>
                              <?php if($errors->has('g-recaptcha-response')): ?>
                                  <span class="invalid-feedback" style="display: block;">
                                      <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                  </span>
                              <?php endif; ?>
                          </div>
                      </div>
                    <?php endif; ?>
                    <button type="submit" class="btn s7__bg-primary text-white w-100"><?php echo e(__('Login')); ?></button>
    
                  </form>
              </div>
          </div>
        </div>
      </div>

      <?php echo $__env->make('admin.layouts.partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php echo $__env->yieldContent('script'); ?>
    </body>
</html><?php /**PATH D:\laragon\www\investpro_23_01_25\scripts\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>